/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.soc.nios2.Nios2ArithmeticAndLogicalInstructions;
import com.cburch.logisim.soc.nios2.Nios2ComparisonInstructions;
import com.cburch.logisim.soc.nios2.Nios2CustomInstructions;
import com.cburch.logisim.soc.nios2.Nios2DataTransferInstructions;
import com.cburch.logisim.soc.nios2.Nios2OtherControlInstructions;
import com.cburch.logisim.soc.nios2.Nios2ProgramControlInstructions;
import com.cburch.logisim.soc.nios2.Nios2ShiftAndRotateInstructions;
import com.cburch.logisim.soc.util.AbstractAssembler;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.LinkedList;

public class Nios2Assembler
extends AbstractAssembler {
    public static final int CUSTOM_REGISTER = 256;
    public static final int CONTROL_REGISTER = 257;

    public Nios2Assembler() {
        super.addAcceptedParameterType(256);
        super.addAcceptedParameterType(257);
        super.addAssemblerExecutionUnit(new Nios2CustomInstructions());
        super.addAssemblerExecutionUnit(new Nios2DataTransferInstructions());
        super.addAssemblerExecutionUnit(new Nios2ArithmeticAndLogicalInstructions());
        super.addAssemblerExecutionUnit(new Nios2ComparisonInstructions());
        super.addAssemblerExecutionUnit(new Nios2ShiftAndRotateInstructions());
        super.addAssemblerExecutionUnit(new Nios2ProgramControlInstructions());
        super.addAssemblerExecutionUnit(new Nios2OtherControlInstructions());
    }

    @Override
    public boolean usesRoundedBrackets() {
        return true;
    }

    @Override
    public String getHighlightStringIdentifier() {
        return "asm/nios2";
    }

    @Override
    public void performUpSpecificOperationsOnTokens(LinkedList<AssemblerToken> tokens) {
        for (AssemblerToken token : tokens) {
            if (token.getType() != 5) continue;
            if (token.getValue().toLowerCase().startsWith("ctl")) {
                token.setType(257);
                continue;
            }
            if (!token.getValue().toLowerCase().startsWith("c")) continue;
            token.setType(256);
        }
    }
}

