/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.gui.prefs.PrefOption;
import com.cburch.logisim.prefs.PrefMonitor;
import com.cburch.logisim.util.StringGetter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefOptionList
implements ActionListener,
PropertyChangeListener {
    private final PrefMonitor<String> pref;
    private final StringGetter labelStr;
    private final JLabel label;
    private final JComboBox<PrefOption> combo;

    public PrefOptionList(PrefMonitor<String> pref, StringGetter labelStr, PrefOption[] options) {
        this.pref = pref;
        this.labelStr = labelStr;
        this.label = new JLabel(labelStr.toString() + " ");
        this.combo = new JComboBox();
        for (PrefOption opt : options) {
            this.combo.addItem(opt);
        }
        this.combo.addActionListener(this);
        pref.addPropertyChangeListener(this);
        this.selectOption(pref.get());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrefOption x = (PrefOption)this.combo.getSelectedItem();
        this.pref.set((String)x.getValue());
    }

    JPanel createJPanel() {
        JPanel ret = new JPanel();
        ret.add(this.label);
        ret.add(this.combo);
        return ret;
    }

    public JComboBox<PrefOption> getJComboBox() {
        return this.combo;
    }

    public JLabel getJLabel() {
        return this.label;
    }

    void localeChanged() {
        this.label.setText(this.labelStr.toString() + " ");
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.pref.isSource(event)) {
            this.selectOption(this.pref.get());
        }
    }

    private void selectOption(Object value) {
        for (int i = this.combo.getItemCount() - 1; i >= 0; --i) {
            PrefOption opt = this.combo.getItemAt(i);
            if (!opt.getValue().equals(value)) continue;
            this.combo.setSelectedItem(opt);
            return;
        }
        this.combo.setSelectedItem(this.combo.getItemAt(0));
    }
}

