/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.opts;

import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.opts.MouseOptions;
import com.cburch.logisim.gui.opts.OptionsPanel;
import com.cburch.logisim.gui.opts.SimulateOptions;
import com.cburch.logisim.gui.opts.ToolbarOptions;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.TableLayout;
import com.cburch.logisim.util.WindowMenuItemManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class OptionsFrame
extends LFrame.Dialog {
    private static final long serialVersionUID = 1L;
    private final MyListener myListener = new MyListener();
    private final WindowMenuManager windowManager = new WindowMenuManager();
    private final OptionsPanel[] panels;
    private final JTabbedPane tabbedPane;

    public OptionsFrame(Project project) {
        super(project);
        project.addLibraryListener(this.myListener);
        project.addProjectListener(event -> {
            int action = event.getAction();
            if (action == 4) {
                this.computeTitle();
            }
        });
        this.panels = new OptionsPanel[]{new SimulateOptions(this), new ToolbarOptions(this), new MouseOptions(this), new RevertPanel(this)};
        this.tabbedPane = new JTabbedPane();
        for (OptionsPanel panel : this.panels) {
            this.tabbedPane.addTab(panel.getTitle(), null, panel, panel.getToolTipText());
        }
        Container contents = this.getContentPane();
        this.tabbedPane.setPreferredSize(new Dimension(AppPreferences.getScaled(450), AppPreferences.getScaled(300)));
        contents.add((Component)this.tabbedPane, "Center");
        LocaleManager.addLocaleListener(this.myListener);
        this.myListener.localeChanged();
        this.pack();
        this.setLocationRelativeTo(project.getFrame());
    }

    private void computeTitle() {
        LogisimFile file = this.project.getLogisimFile();
        String name = file == null ? "???" : file.getName();
        String title = Strings.S.get("optionsFrameTitle", name);
        this.setTitle(title);
    }

    public Options getOptions() {
        return this.project.getLogisimFile().getOptions();
    }

    OptionsPanel[] getPrefPanels() {
        return this.panels;
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.windowManager.frameOpened(this);
        }
        super.setVisible(value);
    }

    private class MyListener
    implements LibraryListener,
    LocaleListener {
        private MyListener() {
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            if (event.getAction() == 6) {
                OptionsFrame.this.computeTitle();
                OptionsFrame.this.windowManager.localeChanged();
            }
        }

        @Override
        public void localeChanged() {
            OptionsFrame.this.computeTitle();
            for (int i = 0; i < OptionsFrame.this.panels.length; ++i) {
                OptionsFrame.this.tabbedPane.setTitleAt(i, OptionsFrame.this.panels[i].getTitle());
                OptionsFrame.this.tabbedPane.setToolTipTextAt(i, OptionsFrame.this.panels[i].getToolTipText());
                OptionsFrame.this.panels[i].localeChanged();
            }
            OptionsFrame.this.windowManager.localeChanged();
        }
    }

    private class WindowMenuManager
    extends WindowMenuItemManager
    implements LocaleListener {
        WindowMenuManager() {
            super(Strings.S.get("optionsFrameMenuItem"), false);
        }

        @Override
        public JFrame getJFrame(boolean create, Component parent) {
            return OptionsFrame.this;
        }

        @Override
        public void localeChanged() {
            String title = OptionsFrame.this.project.getLogisimFile().getDisplayName();
            this.setText(Strings.S.get("optionsFrameMenuItem", title));
        }
    }

    static class RevertPanel
    extends OptionsPanel {
        private static final long serialVersionUID = 1L;
        private final MyListener myListener = new MyListener();
        private final JButton revert = new JButton();

        public RevertPanel(OptionsFrame window) {
            super(window);
            this.setLayout(new TableLayout(1));
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.revert);
            this.revert.addActionListener(this.myListener);
            this.add(buttonPanel);
        }

        @Override
        public String getHelpText() {
            return Strings.S.get("revertHelp");
        }

        @Override
        public String getTitle() {
            return Strings.S.get("revertTitle");
        }

        @Override
        public void localeChanged() {
            this.revert.setText(Strings.S.get("revertButton"));
        }

        private class MyListener
        implements ActionListener {
            private MyListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object src = event.getSource();
                if (src == RevertPanel.this.revert) {
                    RevertPanel.this.getProject().doAction(LogisimFileActions.revertDefaults());
                }
            }
        }
    }
}

