/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class EditPopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private final Listener listener = new Listener();
    private final Map<LogisimMenuItem, JMenuItem> items = new HashMap<LogisimMenuItem, JMenuItem>();

    public EditPopup() {
        this(false);
    }

    public EditPopup(boolean waitForInitialize) {
        if (!waitForInitialize) {
            this.initialize();
        }
    }

    private boolean add(LogisimMenuItem item, String display) {
        if (this.shouldShow(item)) {
            JMenuItem menu = new JMenuItem(display);
            this.items.put(item, menu);
            menu.setEnabled(this.isEnabled(item));
            menu.addActionListener(this.listener);
            this.add(menu);
            return true;
        }
        return false;
    }

    protected abstract void fire(LogisimMenuItem var1);

    protected void initialize() {
        boolean x = false;
        x |= this.add(LogisimMenuBar.CUT, Strings.S.get("editCutItem"));
        if (x |= this.add(LogisimMenuBar.COPY, Strings.S.get("editCopyItem"))) {
            this.addSeparator();
            x = false;
        }
        x |= this.add(LogisimMenuBar.DELETE, Strings.S.get("editClearItem"));
        if (x |= this.add(LogisimMenuBar.DUPLICATE, Strings.S.get("editDuplicateItem"))) {
            this.addSeparator();
            x = false;
        }
        x |= this.add(LogisimMenuBar.RAISE, Strings.S.get("editRaiseItem"));
        x |= this.add(LogisimMenuBar.LOWER, Strings.S.get("editLowerItem"));
        x |= this.add(LogisimMenuBar.RAISE_TOP, Strings.S.get("editRaiseTopItem"));
        if (x |= this.add(LogisimMenuBar.LOWER_BOTTOM, Strings.S.get("editLowerBottomItem"))) {
            this.addSeparator();
            x = false;
        }
        x |= this.add(LogisimMenuBar.ADD_CONTROL, Strings.S.get("editAddControlItem"));
        if (!(x |= this.add(LogisimMenuBar.REMOVE_CONTROL, Strings.S.get("editRemoveControlItem"))) && this.getComponentCount() > 0) {
            this.remove(this.getComponentCount() - 1);
        }
    }

    protected abstract boolean isEnabled(LogisimMenuItem var1);

    protected abstract boolean shouldShow(LogisimMenuItem var1);

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            for (Map.Entry<LogisimMenuItem, JMenuItem> entry : EditPopup.this.items.entrySet()) {
                if (entry.getValue() != source) continue;
                EditPopup.this.fire(entry.getKey());
                return;
            }
        }
    }
}

