/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.gui.main.Selection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

class SelectionSave {
    private Component[] floating;
    private Component[] anchored;

    private SelectionSave() {
    }

    public static SelectionSave create(Selection sel) {
        Collection<Component> selected;
        SelectionSave save = new SelectionSave();
        Collection<Component> lifted = sel.getFloatingComponents();
        if (!lifted.isEmpty()) {
            save.floating = lifted.toArray(new Component[0]);
        }
        if (!(selected = sel.getAnchoredComponents()).isEmpty()) {
            save.anchored = selected.toArray(new Component[0]);
        }
        return save;
    }

    private static boolean isSame(Component[] save, Collection<Component> sel) {
        return save == null ? sel.isEmpty() : SelectionSave.toSet(save).equals(sel);
    }

    private static boolean isSame(Component[] a, Component[] b) {
        if (a == null || a.length == 0) {
            return b == null || b.length == 0;
        }
        if (b == null || b.length == 0) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        return SelectionSave.toSet(a).equals(SelectionSave.toSet(b));
    }

    public boolean isSame(Selection sel) {
        return SelectionSave.isSame(this.floating, sel.getFloatingComponents()) && SelectionSave.isSame(this.anchored, sel.getAnchoredComponents());
    }

    private static HashSet<Component> toSet(Component[] comps) {
        HashSet<Component> ret = new HashSet<Component>(comps.length);
        ret.addAll(Arrays.asList(comps));
        return ret;
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof SelectionSave) {
            SelectionSave o = (SelectionSave)other;
            bl = SelectionSave.isSame(this.floating, o.floating) && SelectionSave.isSame(this.anchored, o.anchored);
        } else {
            bl = false;
        }
        return bl;
    }

    public Component[] getAnchoredComponents() {
        return this.anchored;
    }

    public Component[] getFloatingComponents() {
        return this.floating;
    }

    public int hashCode() {
        int ret = 0;
        if (this.floating != null) {
            for (Component c : this.floating) {
                ret += c.hashCode();
            }
        }
        if (this.anchored != null) {
            for (Component c : this.anchored) {
                ret += c.hashCode();
            }
        }
        return ret;
    }
}

