/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class SelectionAttributes
extends AbstractAttributeSet {
    private static final Attribute<?>[] EMPTY_ATTRIBUTES = new Attribute[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private final Canvas canvas;
    private final Selection selection;
    private final Listener listener;
    private boolean listening;
    private Set<Component> selected;
    private Attribute<?>[] attrs;
    private boolean[] readOnly;
    private Object[] values;
    private List<Attribute<?>> attrsView;

    public SelectionAttributes(Canvas canvas, Selection selection) {
        this.canvas = canvas;
        this.selection = selection;
        this.listener = new Listener();
        this.listening = true;
        this.selected = Collections.emptySet();
        this.attrs = EMPTY_ATTRIBUTES;
        this.values = EMPTY_VALUES;
        this.attrsView = Collections.emptyList();
        selection.addListener(this.listener);
        this.updateList(true);
        this.setListening(true);
    }

    private static LinkedHashMap<Attribute<Object>, Object> computeAttributes(Collection<Component> newSel) {
        LinkedHashMap<Attribute<Object>, Object> attrMap = new LinkedHashMap<Attribute<Object>, Object>();
        Iterator<Component> sit = newSel.iterator();
        if (sit.hasNext()) {
            AttributeSet first = sit.next().getAttributeSet();
            Iterator<Attribute<?>> iterator = first.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute<?> attr;
                Attribute<?> attrObj = attr = iterator.next();
                attrMap.put(attrObj, first.getValue(attr));
            }
            while (sit.hasNext()) {
                AttributeSet next = sit.next().getAttributeSet();
                Iterator<Attribute<Object>> ait = attrMap.keySet().iterator();
                while (ait.hasNext()) {
                    Attribute<Object> attr = ait.next();
                    if (next.containsAttribute(attr)) {
                        Object v = attrMap.get(attr);
                        if (v == null || v.equals(next.getValue(attr))) continue;
                        attrMap.put(attr, null);
                        continue;
                    }
                    ait.remove();
                }
            }
        }
        return attrMap;
    }

    private static boolean computeReadOnly(Collection<Component> sel, Attribute<?> attr) {
        for (Component comp : sel) {
            AttributeSet attrs = comp.getAttributeSet();
            if (!attrs.isReadOnly(attr)) continue;
            return true;
        }
        return false;
    }

    private static Set<Component> createSet(Collection<Component> comps) {
        boolean includeWires = true;
        for (Component comp : comps) {
            if (comp instanceof Wire) continue;
            includeWires = false;
            break;
        }
        if (includeWires) {
            return new HashSet<Component>(comps);
        }
        HashSet<Component> ret = new HashSet<Component>();
        for (Component comp : comps) {
            if (comp instanceof Wire) continue;
            ret.add(comp);
        }
        return ret;
    }

    private static boolean haveSameElements(Collection<Component> a, Collection<Component> b) {
        if (a == null) {
            return CollectionUtil.isNullOrEmpty(b);
        }
        if (b == null) {
            return a.isEmpty();
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Component item : a) {
            if (b.contains(item)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSame(LinkedHashMap<Attribute<Object>, Object> attrMap, Attribute<?>[] oldAttrs, Object[] oldValues) {
        if (oldAttrs.length != attrMap.size()) {
            return false;
        }
        int j = -1;
        for (Map.Entry<Attribute<Object>, Object> entry : attrMap.entrySet()) {
            Attribute<Object> a = entry.getKey();
            if (!oldAttrs[++j].equals(a) || j >= oldValues.length) {
                return false;
            }
            Object ov = oldValues[j];
            Object nv = entry.getValue();
            if (Objects.equals(ov, nv)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        throw new UnsupportedOperationException("SelectionAttributes.copyInto");
    }

    private int findIndex(Attribute<?> attr) {
        if (attr == null) {
            return -1;
        }
        Attribute<?>[] as = this.attrs;
        for (int i = 0; i < as.length; ++i) {
            if (!attr.equals(as[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        Circuit circ = this.canvas.getCircuit();
        return circ != null && this.selected.isEmpty() ? circ.getStaticAttributes().getAttributes() : this.attrsView;
    }

    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        Circuit circ = this.canvas.getCircuit();
        if (circ != null && this.selected.isEmpty()) {
            return circ.getStaticAttributes().getValue(attr);
        }
        int i = this.findIndex(attr);
        Object[] vs = this.values;
        Object ret = i >= 0 && i < vs.length ? vs[i] : null;
        return (V)ret;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        Project proj = this.canvas.getProject();
        Circuit circ = this.canvas.getCircuit();
        if (!proj.getLogisimFile().contains(circ)) {
            return true;
        }
        if (circ != null && this.selected.isEmpty()) {
            return circ.getStaticAttributes().isReadOnly(attr);
        }
        int i = this.findIndex(attr);
        boolean[] ro = this.readOnly;
        return i < 0 || i >= ro.length || ro[i];
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return false;
    }

    private void setListening(boolean value) {
        if (this.listening != value) {
            this.listening = value;
            if (value) {
                this.updateList(false);
            }
        }
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        Circuit circ = this.canvas.getCircuit();
        if (this.selected.isEmpty() && circ != null) {
            circ.getStaticAttributes().setValue(attr, value);
        } else {
            int i = this.findIndex(attr);
            Object[] vs = this.values;
            if (i >= 0 && i < vs.length) {
                vs[i] = value;
                for (Component comp : this.selected) {
                    comp.getAttributeSet().setValue(attr, value);
                }
            }
        }
    }

    private void updateList(boolean ignoreIfSelectionSame) {
        Set<Component> newSel;
        Selection sel = this.selection;
        Set<Component> oldSel = this.selected;
        Set<Component> set = newSel = sel == null ? Collections.emptySet() : SelectionAttributes.createSet(sel.getComponents());
        if (SelectionAttributes.haveSameElements(newSel, oldSel)) {
            if (ignoreIfSelectionSame) {
                return;
            }
            newSel = oldSel;
        } else {
            for (Component o : oldSel) {
                if (newSel.contains(o)) continue;
                o.getAttributeSet().removeAttributeListener(this.listener);
            }
            for (Component o : newSel) {
                if (oldSel.contains(o)) continue;
                o.getAttributeSet().addAttributeListener(this.listener);
            }
        }
        LinkedHashMap<Attribute<Object>, Object> attrMap = SelectionAttributes.computeAttributes(newSel);
        boolean same = SelectionAttributes.isSame(attrMap, this.attrs, this.values);
        if (same) {
            if (newSel != oldSel) {
                this.selected = newSel;
            }
        } else {
            boolean listSame;
            Attribute<?>[] oldAttrs = this.attrs;
            Object[] oldValues = this.values;
            Attribute[] newAttrs = new Attribute[attrMap.size()];
            Object[] newValues = new Object[newAttrs.length];
            boolean[] newReadOnly = new boolean[newAttrs.length];
            int i = -1;
            for (Map.Entry<Attribute<Object>, Object> entry : attrMap.entrySet()) {
                newAttrs[++i] = entry.getKey();
                newValues[i] = entry.getValue();
                newReadOnly[i] = SelectionAttributes.computeReadOnly(newSel, newAttrs[i]);
            }
            if (newSel != oldSel) {
                this.selected = newSel;
            }
            this.attrs = newAttrs;
            this.attrsView = new UnmodifiableList<Attribute>(newAttrs);
            this.values = newValues;
            this.readOnly = newReadOnly;
            boolean bl = listSame = oldAttrs != null && oldAttrs.length == newAttrs.length;
            if (listSame) {
                for (i = 0; i < oldAttrs.length; ++i) {
                    if (oldAttrs[i].equals(newAttrs[i])) continue;
                    listSame = false;
                    break;
                }
            }
            if (listSame) {
                for (i = 0; i < oldValues.length; ++i) {
                    Object oldVal = oldValues[i];
                    Object newVal = newValues[i];
                    boolean sameVals = Objects.equals(oldVal, newVal);
                    if (sameVals) continue;
                    Attribute<?> attr = oldAttrs[i];
                    this.fireAttributeValueChanged(attr, newVal, oldVal);
                }
            } else {
                this.fireAttributeListChanged();
            }
        }
    }

    private class Listener
    implements Selection.Listener,
    AttributeListener {
        private Listener() {
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
            if (SelectionAttributes.this.listening) {
                SelectionAttributes.this.updateList(false);
            }
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            if (SelectionAttributes.this.listening) {
                SelectionAttributes.this.updateList(false);
            }
        }

        @Override
        public void selectionChanged(Selection.Event e) {
            SelectionAttributes.this.updateList(true);
        }
    }
}

