/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;

public class ShowStateIcon
extends BaseIcon {
    private final boolean pressed;

    public ShowStateIcon(boolean pressed) {
        this.pressed = pressed;
    }

    @Override
    protected void paintIcon(Graphics2D gfx) {
        gfx.setStroke(new BasicStroke(AppPreferences.getScaled(1)));
        if (this.pressed) {
            gfx.setColor(Color.MAGENTA.brighter().brighter().brighter());
            gfx.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        }
        gfx.setColor(Color.BLACK);
        gfx.drawRect(0, 0, this.getIconWidth(), this.getIconHeight() / 2);
        Font font = gfx.getFont().deriveFont((float)this.getIconWidth() / 2.0f);
        TextLayout textLayout = new TextLayout("101", font, gfx.getFontRenderContext());
        textLayout.draw(gfx, (float)((double)this.getIconWidth() / 2.0 - textLayout.getBounds().getCenterX()), (float)((double)this.getIconHeight() / 4.0 - textLayout.getBounds().getCenterY()));
        int iconBorder = 2;
        int wh = AppPreferences.getScaled(6);
        int offset = AppPreferences.getScaled(2);
        gfx.setColor(Color.RED);
        gfx.fillOval(offset, offset + this.getIconHeight() / 2, wh, wh);
        gfx.setColor(Color.GREEN);
        gfx.fillOval(offset + this.getIconWidth() / 2, offset + this.getIconHeight() / 2, wh, wh);
        gfx.setColor(Color.BLACK);
        gfx.drawOval(offset, offset + this.getIconHeight() / 2, wh, wh);
        gfx.drawOval(offset + this.getIconWidth() / 2, offset + this.getIconHeight() / 2, wh, wh);
    }
}

