/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.generic.ProjectExplorerLibraryNode;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.tools.Tool;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class ProjectExplorerModel
extends DefaultTreeModel
implements ProjectListener {
    private static final long serialVersionUID = 1L;
    private final JTree uiElement;
    private Project proj;
    private final boolean showMouseTools;

    ProjectExplorerModel(Project proj, JTree gui, boolean showMouseTools) {
        super(null);
        this.proj = proj;
        this.showMouseTools = showMouseTools;
        this.setRoot(new ProjectExplorerLibraryNode(this, proj.getLogisimFile(), gui, showMouseTools));
        proj.addProjectListener(this);
        this.uiElement = gui;
    }

    Node<Tool> findTool(Tool tool) {
        Node root = (Node)this.getRoot();
        if (root == null || tool == null) {
            return null;
        }
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            Node node = (Node)en.nextElement();
            if (node.getValue() != tool) continue;
            Node nodeTool = node;
            return nodeTool;
        }
        return null;
    }

    void fireStructureChanged() {
        ProjectExplorerModel model = this;
        Node root = (Node)this.getRoot();
        SwingUtilities.invokeLater(() -> {
            if (root != null) {
                model.fireTreeNodesChanged(model, root.getUserObjectPath(), null, null);
                model.fireTreeStructureChanged(model, root.getUserObjectPath(), null, null);
            } else {
                model.fireTreeNodesChanged(model, null, null, null);
                model.fireTreeStructureChanged(model, null, null, null);
            }
        });
    }

    @Override
    public void projectChanged(ProjectEvent event) {
        int act = event.getAction();
        if (act == 0) {
            this.setLogisimFile(this.proj.getLogisimFile());
            this.fireStructureChanged();
        }
    }

    private void setLogisimFile(LogisimFile file) {
        Node oldRoot = (Node)this.getRoot();
        oldRoot.decommission();
        this.setRoot(file == null ? null : new ProjectExplorerLibraryNode(this, file, this.uiElement, this.showMouseTools));
        this.fireStructureChanged();
    }

    public void setProject(Project value) {
        Project old = this.proj;
        if (old != null) {
            old.removeProjectListener(this);
        }
        this.setLogisimFile(null);
        this.proj = value;
        if (value != null) {
            value.addProjectListener(this);
            this.setLogisimFile(value.getLogisimFile());
        }
        this.fireStructureChanged();
    }

    public void updateStructure() {
        this.fireStructureChanged();
    }

    static abstract class Node<T>
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        final ProjectExplorerModel model;
        int oldIndex;
        int newIndex;

        Node(ProjectExplorerModel model, T userObject) {
            super(userObject);
            this.model = model;
        }

        abstract Node<T> create(T var1);

        abstract void decommission();

        public void fireNodeChanged() {
            Node parent = (Node)this.getParent();
            if (parent == null) {
                this.model.fireTreeNodesChanged(this, null, null, null);
            } else {
                int[] indices = new int[]{parent.getIndex(this)};
                Object[] items = new Object[]{this.getUserObject()};
                this.model.fireTreeNodesChanged(this, parent.getPath(), indices, items);
            }
        }

        void fireNodesChanged(int[] indices, Node<?>[] children) {
            this.model.fireTreeNodesChanged(this.model, this.getPath(), indices, children);
        }

        void fireNodesInserted(int[] indices, Node<?>[] children) {
            this.model.fireTreeNodesInserted(this.model, this.getPath(), indices, children);
        }

        void fireNodesRemoved(int[] indices, Node<?>[] children) {
            this.model.fireTreeNodesRemoved(this.model, this.getPath(), indices, children);
        }

        void fireStructureChanged() {
            this.model.fireStructureChanged();
        }

        ProjectExplorerModel getModel() {
            return this.model;
        }

        public T getValue() {
            Object val = this.getUserObject();
            return (T)val;
        }
    }
}

