/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.toolbar.AbstractToolbarModel;
import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.draw.tools.CurveTool;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.draw.tools.LineTool;
import com.cburch.draw.tools.OvalTool;
import com.cburch.draw.tools.PolyTool;
import com.cburch.draw.tools.RectangleTool;
import com.cburch.draw.tools.RoundRectangleTool;
import com.cburch.draw.tools.TextTool;
import com.cburch.draw.tools.ToolbarToolItem;
import com.cburch.logisim.gui.appear.ResetAppearanceTool;
import com.cburch.logisim.gui.appear.ShowStateTool;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AppearanceToolbarModel
extends AbstractToolbarModel
implements PropertyChangeListener {
    private final Canvas canvas;
    private final List<ToolbarItem> items;

    public AppearanceToolbarModel(AbstractTool selectTool, ShowStateTool showStateTool, Canvas canvas, DrawingAttributeSet attrs) {
        this.canvas = canvas;
        AbstractTool[] tools = new AbstractTool[]{selectTool, new TextTool(attrs), new LineTool(attrs), new CurveTool(attrs), new PolyTool(false, attrs), new RectangleTool(attrs), new RoundRectangleTool(attrs), new OvalTool(attrs), new PolyTool(true, attrs)};
        ArrayList<ToolbarItem> rawItems = new ArrayList<ToolbarItem>();
        for (AbstractTool tool : tools) {
            rawItems.add(new ToolbarToolItem(tool));
        }
        rawItems.add(new ResetAppearanceTool(canvas, true));
        rawItems.add(new ResetAppearanceTool(canvas, false));
        rawItems.add(showStateTool);
        this.items = Collections.unmodifiableList(rawItems);
        canvas.addPropertyChangeListener("tool", this);
    }

    AbstractTool getFirstTool() {
        ToolbarToolItem item = (ToolbarToolItem)this.items.get(0);
        return item.getTool();
    }

    @Override
    public List<ToolbarItem> getItems() {
        return this.items;
    }

    @Override
    public boolean isSelected(ToolbarItem item) {
        if (item instanceof ToolbarToolItem) {
            ToolbarToolItem toolItem = (ToolbarToolItem)item;
            AbstractTool tool = toolItem.getTool();
            return this.canvas != null && tool == this.canvas.getTool();
        }
        return false;
    }

    @Override
    public void itemSelected(ToolbarItem item) {
        if (item instanceof ToolbarToolItem) {
            ToolbarToolItem toolItem = (ToolbarToolItem)item;
            AbstractTool tool = toolItem.getTool();
            this.canvas.setTool(tool);
            this.fireToolbarAppearanceChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("tool".equals(prop)) {
            this.fireToolbarAppearanceChanged();
        }
    }
}

