/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.std.wiring.Clock;
import java.util.ArrayList;
import java.util.List;

public class ClockSourceContainer {
    final ArrayList<Component> sources = new ArrayList();
    boolean requiresFpgaGlobalClock = false;

    public void clear() {
        this.sources.clear();
        this.requiresFpgaGlobalClock = false;
    }

    private boolean equals(Component comp1, Component comp2) {
        if (comp1.getAttributeSet().getValue(Clock.ATTR_PHASE).intValue() != comp2.getAttributeSet().getValue(Clock.ATTR_PHASE).intValue()) {
            return false;
        }
        if (comp1.getAttributeSet().getValue(Clock.ATTR_HIGH).intValue() != comp2.getAttributeSet().getValue(Clock.ATTR_HIGH).intValue()) {
            return false;
        }
        return comp1.getAttributeSet().getValue(Clock.ATTR_LOW).intValue() == comp2.getAttributeSet().getValue(Clock.ATTR_LOW).intValue();
    }

    public int getClockId(Component comp) {
        if (!(comp.getFactory() instanceof Clock)) {
            return -1;
        }
        for (Component clock : this.sources) {
            if (!this.equals(comp, clock)) continue;
            return this.sources.indexOf(clock);
        }
        this.sources.add(comp);
        return this.sources.indexOf(comp);
    }

    public int getNrofSources() {
        return this.sources.size();
    }

    public List<Component> getSources() {
        return this.sources;
    }

    public boolean getRequiresFpgaGlobalClock() {
        return this.requiresFpgaGlobalClock;
    }

    public void setRequiresFpgaGlobalClock() {
        this.requiresFpgaGlobalClock = true;
    }
}

