/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.data.TestException;
import com.cburch.logisim.data.Value;
import java.util.ArrayList;
import java.util.List;

public class FailException
extends TestException {
    private static final long serialVersionUID = 1L;
    private final int column;
    private final Value expected;
    private final Value computed;
    private final ArrayList<FailException> more = new ArrayList();

    public FailException(int column, String columnName, Value expected, Value computed) {
        super(columnName + " = " + computed.toDisplayString(2) + " (expected " + expected.toDisplayString(2) + ")");
        this.column = column;
        this.expected = expected;
        this.computed = computed;
    }

    public void add(FailException another) {
        this.more.add(another);
        this.more.addAll(another.getMore());
        another.clearMore();
    }

    public int getColumn() {
        return this.column;
    }

    public Value getComputed() {
        return this.computed;
    }

    public Value getExpected() {
        return this.expected;
    }

    public List<FailException> getMore() {
        return this.more;
    }

    public void clearMore() {
        this.more.clear();
    }

    public List<FailException> getAll() {
        ArrayList<FailException> ret = new ArrayList<FailException>();
        ret.add(this);
        ret.addAll(this.more);
        return ret;
    }
}

