/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.comp;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;

public class EndData {
    public static final int INPUT_ONLY = 1;
    public static final int OUTPUT_ONLY = 2;
    public static final int INPUT_OUTPUT = 3;
    private final Location loc;
    private final BitWidth width;
    private final int i_o;
    private final boolean exclusive;

    public EndData(Location loc, BitWidth width, int type) {
        this(loc, width, type, type == 2);
    }

    public EndData(Location loc, BitWidth width, int type, boolean exclusive) {
        this.loc = loc;
        this.width = width;
        this.i_o = type;
        this.exclusive = exclusive;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EndData)) {
            return false;
        }
        EndData o = (EndData)other;
        if (other == this) {
            return true;
        }
        return o.loc.equals(this.loc) && o.width.equals(this.width) && o.i_o == this.i_o && o.exclusive == this.exclusive;
    }

    public Location getLocation() {
        return this.loc;
    }

    public int getType() {
        return this.i_o;
    }

    public BitWidth getWidth() {
        return this.width;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isInput() {
        return (this.i_o & 1) != 0;
    }

    public boolean isOutput() {
        return (this.i_o & 2) != 0;
    }
}

