/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.appear.AppearanceElement;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AppearanceAnchor
extends AppearanceElement {
    public static final Attribute<Direction> FACING = Attributes.forDirection("facing", Strings.S.getter("appearanceFacingAttr"));
    static final List<Attribute<?>> ATTRIBUTES = UnmodifiableList.create(new Attribute[]{FACING});
    private static final int RADIUS = 3;
    private static final int INDICATOR_LENGTH = 8;
    private static final Color SYMBOL_COLOR = new Color(0, 128, 0);
    private Direction factingDirection = Direction.EAST;

    public AppearanceAnchor(Location location) {
        super(location);
    }

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        if (super.isInCircle(loc, 3)) {
            return true;
        }
        Location center = this.getLocation();
        Location end = center.translate(this.factingDirection, 11);
        return this.factingDirection == Direction.EAST || this.factingDirection == Direction.WEST ? Math.abs(loc.getY() - center.getY()) < 2 && loc.getX() < center.getX() != loc.getX() < end.getX() : Math.abs(loc.getX() - center.getX()) < 2 && loc.getY() < center.getY() != loc.getY() < end.getY();
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public Bounds getBounds() {
        Bounds bds = super.getBounds(3);
        Location center = this.getLocation();
        Location end = center.translate(this.factingDirection, 11);
        return bds.add(end);
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("circuitAnchor");
    }

    public Direction getFacingDirection() {
        return this.factingDirection;
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        Location c = this.getLocation();
        Location end = c.translate(this.factingDirection, 11);
        return UnmodifiableList.create(new Handle[]{new Handle(this, c), new Handle(this, end)});
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        return (V)(attr == FACING ? this.factingDirection : super.getValue(attr));
    }

    @Override
    public boolean matches(CanvasObject other) {
        if (other instanceof AppearanceAnchor) {
            AppearanceAnchor that = (AppearanceAnchor)other;
            return super.matches(that) && this.factingDirection.equals(that.factingDirection);
        }
        return false;
    }

    @Override
    public int matchesHashCode() {
        return super.matchesHashCode() * 31 + this.factingDirection.hashCode();
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        Location location = this.getLocation();
        int x = location.getX();
        int y = location.getY();
        g.setColor(SYMBOL_COLOR);
        g.drawOval(x - 3, y - 3, 6, 6);
        Location e0 = location.translate(this.factingDirection, 3);
        Location e1 = location.translate(this.factingDirection, 11);
        g.drawLine(e0.getX(), e0.getY(), e1.getX(), e1.getY());
    }

    @Override
    public Element toSvgElement(Document doc) {
        Location loc = this.getLocation();
        Element ret = doc.createElement("circ-anchor");
        ret.setAttribute("x", Integer.toString(loc.getX()));
        ret.setAttribute("y", Integer.toString(loc.getY()));
        ret.setAttribute("facing", this.factingDirection.toString());
        return ret;
    }

    @Override
    protected void updateValue(Attribute<?> attr, Object value) {
        if (attr == FACING) {
            this.factingDirection = (Direction)value;
        } else {
            super.updateValue(attr, value);
        }
    }
}

