/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Direction;

class SplitterParameters {
    private final int dxEnd0;
    private final int dyEnd0;
    private final int ddxEnd;
    private final int ddyEnd;
    private final int dxEndSpine;
    private final int dyEndSpine;
    private final int dxSpine0;
    private final int dySpine0;
    private final int dxSpine1;
    private final int dySpine1;
    private final int textAngle;
    private final int halign;
    private final int valign;

    SplitterParameters(SplitterAttributes attrs) {
        AttributeOption appear = attrs.appear;
        byte fanout = attrs.fanout;
        Direction facing = attrs.facing;
        int justify = appear == SplitterAttributes.APPEAR_CENTER || appear == SplitterAttributes.APPEAR_LEGACY ? 0 : (appear == SplitterAttributes.APPEAR_RIGHT ? 1 : -1);
        int width = 20;
        int gap = attrs.spacing * 10;
        int offs = 6;
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int m;
            int n = m = facing == Direction.NORTH ? 1 : -1;
            this.dxEnd0 = justify == 0 ? gap * ((fanout + 1) / 2 - 1) : (m * justify < 0 ? -10 : 10 + gap * (fanout - 1));
            this.dyEnd0 = -m * 20;
            this.ddxEnd = -gap;
            this.ddyEnd = 0;
            this.dxEndSpine = 0;
            this.dyEndSpine = m * 14;
            this.dxSpine0 = m * justify * (10 + gap * (fanout - 1) - 1);
            this.dySpine0 = -m * 6;
            this.dxSpine1 = m * justify * 6;
            this.dySpine1 = -m * 6;
            this.textAngle = 90;
            this.halign = m > 0 ? 1 : -1;
            this.valign = 1;
        } else {
            int m = facing == Direction.WEST ? -1 : 1;
            this.dxEnd0 = m * 20;
            this.dyEnd0 = justify == 0 ? -gap * (fanout / 2) : (m * justify > 0 ? 10 : -(10 + gap * (fanout - 1)));
            this.ddxEnd = 0;
            this.ddyEnd = gap;
            this.dxEndSpine = -m * 14;
            this.dyEndSpine = 0;
            this.dxSpine0 = m * 6;
            this.dySpine0 = m * justify * (10 + gap * (fanout - 1) - 1);
            this.dxSpine1 = m * 6;
            this.dySpine1 = m * justify * 6;
            this.textAngle = 0;
            this.halign = m > 0 ? -1 : 1;
            this.valign = m * justify < 0 ? -1 : 1;
        }
    }

    public int getEnd0X() {
        return this.dxEnd0;
    }

    public int getEnd0Y() {
        return this.dyEnd0;
    }

    public int getEndToEndDeltaX() {
        return this.ddxEnd;
    }

    public int getEndToEndDeltaY() {
        return this.ddyEnd;
    }

    public int getEndToSpineDeltaX() {
        return this.dxEndSpine;
    }

    public int getEndToSpineDeltaY() {
        return this.dyEndSpine;
    }

    public int getSpine0X() {
        return this.dxSpine0;
    }

    public int getSpine0Y() {
        return this.dySpine0;
    }

    public int getSpine1X() {
        return this.dxSpine1;
    }

    public int getSpine1Y() {
        return this.dySpine1;
    }

    public int getTextAngle() {
        return this.textAngle;
    }

    public int getTextHorzAlign() {
        return this.halign;
    }

    public int getTextVertAlign() {
        return this.valign;
    }
}

