/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutatorImpl;
import com.cburch.logisim.circuit.CircuitTransaction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CircuitLocker {
    private static final AtomicInteger nextSerialNumber = new AtomicInteger(0);
    private final int serialNumber = nextSerialNumber.getAndIncrement();
    private final ReadWriteLock circuitLock = new ReentrantReadWriteLock();
    private Thread mutatingThread = null;
    private CircuitMutatorImpl mutatingMutator = null;

    static Map<Circuit, Lock> acquireLocks(CircuitTransaction xn, CircuitMutatorImpl mutator) {
        Map<Circuit, Integer> requests = xn.getAccessedCircuits();
        HashMap<Circuit, Lock> circuitLocks = new HashMap<Circuit, Lock>();
        Circuit[] lockOrder = requests.keySet().toArray(new Circuit[0]);
        Arrays.sort(lockOrder, new CircuitComparator());
        try {
            for (Circuit circ : lockOrder) {
                Thread curThread;
                Integer access = requests.get(circ);
                CircuitLocker locker = circ.getLocker();
                if (access == CircuitTransaction.READ_ONLY) {
                    Lock lock = locker.circuitLock.readLock();
                    lock.lock();
                    circuitLocks.put(circ, lock);
                    continue;
                }
                if (access != CircuitTransaction.READ_WRITE || locker.mutatingThread == (curThread = Thread.currentThread())) continue;
                Lock lock = locker.circuitLock.writeLock();
                lock.lock();
                circuitLocks.put(circ, lock);
                locker.mutatingThread = Thread.currentThread();
                if (mutator == null) {
                    mutator = new CircuitMutatorImpl();
                }
                locker.mutatingMutator = mutator;
            }
        }
        catch (RuntimeException t) {
            CircuitLocker.releaseLocks(circuitLocks);
            throw t;
        }
        return circuitLocks;
    }

    static void releaseLocks(Map<Circuit, Lock> locks) {
        Thread curThread = Thread.currentThread();
        for (Map.Entry<Circuit, Lock> entry : locks.entrySet()) {
            Circuit circ = entry.getKey();
            Lock lock = entry.getValue();
            CircuitLocker locker = circ.getLocker();
            if (locker.mutatingThread == curThread) {
                locker.mutatingThread = null;
                locker.mutatingMutator = null;
            }
            lock.unlock();
        }
    }

    CircuitLocker() {
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    void checkForWritePermission(String operationName, Circuit circuit) {
        if (this.mutatingThread != Thread.currentThread()) {
            throw new LockException(operationName + " outside transaction", circuit, this.serialNumber, this.mutatingThread, this.mutatingMutator);
        }
    }

    public void execute(CircuitTransaction xn) {
        if (this.mutatingThread == Thread.currentThread()) {
            xn.run(this.mutatingMutator);
        } else {
            xn.execute();
        }
    }

    CircuitMutatorImpl getMutator() {
        return this.mutatingMutator;
    }

    public boolean hasWriteLock() {
        return this.mutatingThread == Thread.currentThread();
    }

    private static class CircuitComparator
    implements Comparator<Circuit> {
        private CircuitComparator() {
        }

        @Override
        public int compare(Circuit a, Circuit b) {
            int an = a.getLocker().serialNumber;
            int bn = b.getLocker().serialNumber;
            return an - bn;
        }
    }

    public static class LockException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;
        private final Circuit circuit;
        private final int serialNumber;
        private final transient Thread mutatingThread;
        private final CircuitMutatorImpl mutatingMutator;

        public LockException(String msg, Circuit circ, int serial, Thread thread, CircuitMutatorImpl mutator) {
            super(msg);
            this.circuit = circ;
            this.serialNumber = serial;
            this.mutatingThread = thread;
            this.mutatingMutator = mutator;
        }

        public Circuit getCircuit() {
            return this.circuit;
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        public Thread getMutatingThread() {
            return this.mutatingThread;
        }

        public CircuitMutatorImpl getCircuitMutator() {
            return this.mutatingMutator;
        }
    }
}

