/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.file;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.CsvInterpretor;
import com.cburch.logisim.analyze.data.CsvParameter;
import com.cburch.logisim.analyze.file.TruthtableFileFilter;
import com.cburch.logisim.analyze.gui.CsvReadParameterDialog;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableList;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class TruthtableCsvFile {
    public static final FileFilter FILE_FILTER = new TruthtableFileFilter(Strings.S.getter("tableCsvFileFilter"), ".csv");
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE = '\"';

    public static void doSave(File file, AnalyzerModel model) throws IOException {
        VariableList inputs = model.getInputs();
        VariableList outputs = model.getOutputs();
        if (inputs.vars.isEmpty() || outputs.vars.isEmpty()) {
            return;
        }
        try (PrintStream out = new PrintStream(file);){
            int j;
            String name;
            Var cur;
            int i;
            TruthTable tt = model.getTruthTable();
            tt.compactVisibleRows();
            for (i = 0; i < inputs.vars.size(); ++i) {
                cur = inputs.vars.get(i);
                name = cur.width == 1 ? cur.name : cur.name + "[" + (cur.width - 1) + "..0]";
                out.print("\"" + name + "\",");
                for (j = 1; j < cur.width; ++j) {
                    out.print(',');
                }
            }
            out.print("\"|\"");
            for (i = 0; i < outputs.vars.size(); ++i) {
                out.print(',');
                cur = outputs.vars.get(i);
                name = cur.width == 1 ? cur.name : cur.name + "[" + (cur.width - 1) + "..0]";
                out.print("\"" + name + "\"");
                for (j = 1; j < cur.width; ++j) {
                    out.print(',');
                }
            }
            out.println();
            for (int row = 0; row < tt.getVisibleRowCount(); ++row) {
                Entry entry;
                int i2;
                for (i2 = 0; i2 < inputs.bits.size(); ++i2) {
                    entry = tt.getVisibleInputEntry(row, i2);
                    out.print(entry.getDescription() + ",");
                }
                out.print("\"|\"");
                for (i2 = 0; i2 < outputs.bits.size(); ++i2) {
                    out.print(',');
                    entry = tt.getVisibleOutputEntry(row, i2);
                    out.print(entry.getDescription());
                }
                out.println();
            }
        }
    }

    public static void doLoad(File file, AnalyzerModel model, JFrame parentFrame) throws IOException {
        CsvParameter param = new CsvParameter();
        new CsvReadParameterDialog(param, file, parentFrame);
        if (!param.isValid()) {
            return;
        }
        CsvInterpretor cin = new CsvInterpretor(file, param, parentFrame);
        cin.getTruthTable(model);
    }
}

