/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.util.EventSourceWeakSupport;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DrawingAttributeSet
implements AttributeSet,
Cloneable {
    static final List<Attribute<?>> ATTRS_ALL = UnmodifiableList.create(new Attribute[]{DrawAttr.FONT, DrawAttr.HALIGNMENT, DrawAttr.VALIGNMENT, DrawAttr.PAINT_TYPE, DrawAttr.STROKE_WIDTH, DrawAttr.STROKE_COLOR, DrawAttr.FILL_COLOR, DrawAttr.TEXT_DEFAULT_FILL, DrawAttr.CORNER_RADIUS});
    static final List<Object> DEFAULTS_ALL = Arrays.asList(DrawAttr.DEFAULT_FONT, DrawAttr.HALIGN_CENTER, DrawAttr.VALIGN_MIDDLE, DrawAttr.PAINT_STROKE, 1, Color.BLACK, Color.WHITE, Color.BLACK, 10);
    private final List<Attribute<?>> attrs;
    private EventSourceWeakSupport<AttributeListener> listeners = new EventSourceWeakSupport();
    private List<Object> values;

    public DrawingAttributeSet() {
        this.attrs = ATTRS_ALL;
        this.values = DEFAULTS_ALL;
    }

    @Override
    public void addAttributeListener(AttributeListener l) {
        this.listeners.add(l);
    }

    public <E extends CanvasObject> E applyTo(E drawable) {
        AbstractCanvasObject d = (AbstractCanvasObject)drawable;
        for (int i = 0; i < d.getAttributes().size(); ++i) {
            Attribute<?> attr;
            Attribute<?> a = attr = d.getAttributes().get(i);
            if (attr == DrawAttr.FILL_COLOR && this.containsAttribute(DrawAttr.TEXT_DEFAULT_FILL)) {
                d.setValue(a, this.getValue(DrawAttr.TEXT_DEFAULT_FILL));
                continue;
            }
            if (!this.containsAttribute(a)) continue;
            d.setValue(a, this.getValue(a));
        }
        return drawable;
    }

    @Override
    public Object clone() {
        try {
            DrawingAttributeSet ret = (DrawingAttributeSet)super.clone();
            ret.listeners = new EventSourceWeakSupport();
            ret.values = new ArrayList<Object>(this.values);
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean containsAttribute(Attribute<?> attr) {
        return this.attrs.contains(attr);
    }

    public AttributeSet createSubset(AbstractTool tool) {
        return new Restriction(tool);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        for (Attribute<?> attr : this.attrs) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.attrs;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        Iterator<Attribute<?>> ait = this.attrs.iterator();
        Iterator<Object> vit = this.values.iterator();
        while (ait.hasNext()) {
            Attribute<?> a = ait.next();
            Object v = vit.next();
            if (!a.equals(attr)) continue;
            return (V)v;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return false;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave();
    }

    @Override
    public void removeAttributeListener(AttributeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setReadOnly(Attribute<?> attr, boolean value) {
        throw new UnsupportedOperationException("setReadOnly");
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        Iterator<Attribute<?>> ait = this.attrs.iterator();
        ListIterator<Object> vit = this.values.listIterator();
        while (ait.hasNext()) {
            Attribute<?> a = ait.next();
            vit.next();
            if (!a.equals(attr)) continue;
            vit.set(value);
            AttributeEvent event = new AttributeEvent(this, attr, value, null);
            for (AttributeListener listener : this.listeners) {
                listener.attributeValueChanged(event);
            }
            if (attr == DrawAttr.PAINT_TYPE) {
                event = new AttributeEvent(this);
                for (AttributeListener listener : this.listeners) {
                    listener.attributeListChanged(event);
                }
            }
            return;
        }
        throw new IllegalArgumentException(attr.toString());
    }

    private class Restriction
    extends AbstractAttributeSet
    implements AttributeListener {
        private final AbstractTool tool;
        private List<Attribute<?>> selectedAttrs;
        private List<Attribute<?>> selectedView;

        Restriction(AbstractTool tool) {
            this.tool = tool;
            this.updateAttributes();
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
            this.fireAttributeListChanged();
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            if (this.selectedAttrs.contains(e.getAttribute())) {
                Attribute<?> attr = e.getAttribute();
                this.fireAttributeValueChanged(attr, e.getValue(), e.getOldValue());
            }
            this.updateAttributes();
        }

        @Override
        protected void copyInto(AbstractAttributeSet dest) {
            DrawingAttributeSet.this.addAttributeListener(this);
        }

        @Override
        public List<Attribute<?>> getAttributes() {
            return this.selectedView;
        }

        @Override
        public <V> V getValue(Attribute<V> attr) {
            return DrawingAttributeSet.this.getValue(attr);
        }

        @Override
        public <V> void setValue(Attribute<V> attr, V value) {
            DrawingAttributeSet.this.setValue(attr, value);
            this.updateAttributes();
        }

        private void updateAttributes() {
            List<Object> toolAttrs = this.tool == null ? Collections.emptyList() : this.tool.getAttributes();
            if (!toolAttrs.equals(this.selectedAttrs)) {
                this.selectedAttrs = new ArrayList(toolAttrs);
                this.selectedView = Collections.unmodifiableList(this.selectedAttrs);
                DrawingAttributeSet.this.addAttributeListener(this);
                this.fireAttributeListChanged();
            }
        }
    }
}

