/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.model;

import com.cburch.draw.canvas.Selection;
import com.cburch.draw.model.AttributeMapKey;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasModelEvent;
import com.cburch.draw.model.CanvasModelListener;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.DrawingOverlaps;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.model.ReorderRequest;
import com.cburch.draw.shapes.Text;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Drawing
implements CanvasModel {
    private final EventSourceWeakSupport<CanvasModelListener> listeners = new EventSourceWeakSupport();
    private final ArrayList<CanvasObject> canvasObjects = new ArrayList();
    private final DrawingOverlaps overlaps = new DrawingOverlaps();

    @Override
    public void addCanvasModelListener(CanvasModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void addObjects(int index, Collection<? extends CanvasObject> shapes) {
        LinkedHashMap<CanvasObject, Integer> indexes = new LinkedHashMap<CanvasObject, Integer>();
        int i = index;
        for (CanvasObject canvasObject : shapes) {
            indexes.put(canvasObject, i);
            ++i;
        }
        this.addObjectsHelp(indexes);
    }

    @Override
    public void addObjects(Map<? extends CanvasObject, Integer> shapes) {
        this.addObjectsHelp(shapes);
    }

    private void addObjectsHelp(Map<? extends CanvasObject, Integer> shapes) {
        CanvasModelEvent e = CanvasModelEvent.forAdd(this, shapes.keySet());
        if (!shapes.isEmpty() && this.isChangeAllowed(e)) {
            for (Map.Entry<? extends CanvasObject, Integer> entry : shapes.entrySet()) {
                CanvasObject shape = entry.getKey();
                Integer index = entry.getValue();
                this.canvasObjects.add(index, shape);
                this.overlaps.addShape(shape);
            }
            this.fireChanged(e);
        }
    }

    @Override
    public Handle deleteHandle(Handle handle) {
        CanvasModelEvent e = CanvasModelEvent.forDeleteHandle(this, handle);
        if (!this.isChangeAllowed(e)) {
            return null;
        }
        CanvasObject o = handle.getObject();
        Handle ret = o.deleteHandle(handle);
        this.overlaps.invalidateShape(o);
        this.fireChanged(e);
        return ret;
    }

    private void fireChanged(CanvasModelEvent e) {
        for (CanvasModelListener listener : this.listeners) {
            listener.modelChanged(e);
        }
    }

    @Override
    public List<CanvasObject> getObjectsFromBottom() {
        return Collections.unmodifiableList(this.canvasObjects);
    }

    @Override
    public List<CanvasObject> getObjectsFromTop() {
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>(this.getObjectsFromBottom());
        Collections.reverse(ret);
        return ret;
    }

    @Override
    public Collection<CanvasObject> getObjectsIn(Bounds bds) {
        ArrayList<CanvasObject> ret = null;
        for (CanvasObject shape : this.getObjectsFromBottom()) {
            if (!bds.contains(shape.getBounds())) continue;
            if (ret == null) {
                ret = new ArrayList<CanvasObject>();
            }
            ret.add(shape);
        }
        return ret == null ? Collections.emptyList() : ret;
    }

    @Override
    public Collection<CanvasObject> getObjectsOverlapping(CanvasObject shape) {
        return this.overlaps.getObjectsOverlapping(shape);
    }

    @Override
    public void insertHandle(Handle desired, Handle previous) {
        CanvasObject obj = desired.getObject();
        CanvasModelEvent e = CanvasModelEvent.forInsertHandle(this, desired);
        if (this.isChangeAllowed(e)) {
            obj.insertHandle(desired, previous);
            this.overlaps.invalidateShape(obj);
            this.fireChanged(e);
        }
    }

    protected boolean isChangeAllowed(CanvasModelEvent e) {
        return true;
    }

    @Override
    public Handle moveHandle(HandleGesture gesture) {
        CanvasModelEvent e = CanvasModelEvent.forMoveHandle(this, gesture);
        CanvasObject o = gesture.getHandle().getObject();
        if (this.canvasObjects.contains(o) && (gesture.getDeltaX() != 0 || gesture.getDeltaY() != 0) && this.isChangeAllowed(e)) {
            Handle moved = o.moveHandle(gesture);
            gesture.setResultingHandle(moved);
            this.overlaps.invalidateShape(o);
            this.fireChanged(e);
            return moved;
        }
        return null;
    }

    @Override
    public void paint(Graphics g, Selection selection) {
        Set<CanvasObject> suppressed = selection.getDrawsSuppressed();
        for (CanvasObject shape : this.getObjectsFromBottom()) {
            Graphics dup = g.create();
            if (suppressed.contains(shape)) {
                selection.drawSuppressed(dup, shape);
            } else {
                shape.paint(dup, null);
            }
            dup.dispose();
        }
    }

    @Override
    public void removeCanvasModelListener(CanvasModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void removeObjects(Collection<? extends CanvasObject> shapes) {
        ArrayList<CanvasObject> found = this.restrict(shapes);
        CanvasModelEvent e = CanvasModelEvent.forRemove(this, found);
        if (!found.isEmpty() && this.isChangeAllowed(e)) {
            for (CanvasObject shape : found) {
                this.canvasObjects.remove(shape);
                this.overlaps.removeShape(shape);
            }
            this.fireChanged(e);
        }
    }

    @Override
    public void reorderObjects(List<ReorderRequest> requests) {
        boolean hasEffect = false;
        for (ReorderRequest r : requests) {
            if (r.getFromIndex() == r.getToIndex()) continue;
            hasEffect = true;
            break;
        }
        CanvasModelEvent e = CanvasModelEvent.forReorder(this, requests);
        if (hasEffect && this.isChangeAllowed(e)) {
            for (ReorderRequest r : requests) {
                if (this.canvasObjects.get(r.getFromIndex()) != r.getObject()) {
                    throw new IllegalArgumentException("object not present at indicated index: " + r.getFromIndex());
                }
                this.canvasObjects.remove(r.getFromIndex());
                this.canvasObjects.add(r.getToIndex(), r.getObject());
            }
            this.fireChanged(e);
        }
    }

    private ArrayList<CanvasObject> restrict(Collection<? extends CanvasObject> shapes) {
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>(shapes.size());
        for (CanvasObject canvasObject : shapes) {
            if (!this.canvasObjects.contains(canvasObject)) continue;
            ret.add(canvasObject);
        }
        return ret;
    }

    @Override
    public void setAttributeValues(Map<AttributeMapKey, Object> values) {
        HashMap<AttributeMapKey, Object> oldValues = new HashMap<AttributeMapKey, Object>();
        for (AttributeMapKey key : values.keySet()) {
            Attribute<?> attr = key.getAttribute();
            Object oldValue = key.getObject().getValue(attr);
            oldValues.put(key, oldValue);
        }
        CanvasModelEvent e = CanvasModelEvent.forChangeAttributes(this, oldValues, values);
        if (this.isChangeAllowed(e)) {
            for (Map.Entry<AttributeMapKey, Object> entry : values.entrySet()) {
                AttributeMapKey key = entry.getKey();
                CanvasObject shape = key.getObject();
                Attribute<?> attr = key.getAttribute();
                shape.setValue(attr, entry.getValue());
                this.overlaps.invalidateShape(shape);
            }
            this.fireChanged(e);
        }
    }

    @Override
    public void setText(Text text, String value) {
        String oldValue = text.getText();
        CanvasModelEvent e = CanvasModelEvent.forChangeText(this, text, oldValue, value);
        if (this.canvasObjects.contains(text) && !oldValue.equals(value) && this.isChangeAllowed(e)) {
            text.setText(value);
            this.overlaps.invalidateShape(text);
            this.fireChanged(e);
        }
    }

    @Override
    public void translateObjects(Collection<? extends CanvasObject> shapes, int dx, int dy) {
        ArrayList<CanvasObject> found = this.restrict(shapes);
        CanvasModelEvent e = CanvasModelEvent.forTranslate(this, found);
        if (!found.isEmpty() && (dx != 0 || dy != 0) && this.isChangeAllowed(e)) {
            for (CanvasObject canvasObject : shapes) {
                canvasObject.translate(dx, dy);
                this.overlaps.invalidateShape(canvasObject);
            }
            this.fireChanged(e);
        }
    }
}

