/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.contextualmenu;

import com.bric.colorpicker.contextualmenu.ContextualMenu;
import com.bric.colorpicker.contextualmenu.ContextualMenuImpl;
import javax.swing.JComponent;

public final class ContextualMenuHelper {
    private ContextualMenuHelper() {
    }

    public static void clear(JComponent component) {
        ContextualMenu cm = (ContextualMenu)component.getClientProperty(ContextualMenu.MENU_KEY);
        if (cm == null) {
            return;
        }
        cm.removeAll();
    }

    public static void add(JComponent component, String menuItemName, Runnable runnable) {
        ContextualMenu cmh = ContextualMenuHelper.getContextualMenuHelper(component);
        cmh.add(menuItemName, runnable);
    }

    private static ContextualMenu getContextualMenuHelper(JComponent jc) {
        ContextualMenu cmh = (ContextualMenu)jc.getClientProperty(ContextualMenu.MENU_KEY);
        if (cmh == null) {
            cmh = new ContextualMenuImpl();
            cmh.addComponent(jc);
            jc.putClientProperty(ContextualMenu.MENU_KEY, cmh);
        }
        return cmh;
    }
}

