/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.std.io.Button;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class AbstractSimpleIoHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    private final boolean isInputComponent;

    public AbstractSimpleIoHdlGeneratorFactory(boolean isInputComponent) {
        this.isInputComponent = isInputComponent;
    }

    @Override
    public LineBuffer getInlinedCode(Netlist nets, Long componentId, netlistComponent componentInfo, String circuitName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        HashMap<String, String> wires = new HashMap<String, String>();
        for (int i = 0; i < componentInfo.nrOfEnds(); ++i) {
            if (componentInfo.isEndConnected(i) && this.isInputComponent) {
                boolean pressPassive = componentInfo.getComponent().getAttributeSet().getValue(Button.ATTR_PRESS) == Button.BUTTON_PRESS_PASSIVE;
                String destination = Hdl.getNetName(componentInfo, i, true, nets);
                String source = LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", pressPassive ? Hdl.notOperator() : "", "logisimInputBubbles", componentInfo.getLocalBubbleInputStartId() + i);
                wires.put(destination, source);
            }
            if (this.isInputComponent) continue;
            wires.put(LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", "logisimOutputBubbles", componentInfo.getLocalBubbleOutputStartId() + i), Hdl.getNetName(componentInfo, i, true, nets));
        }
        Hdl.addAllWiresSorted(contents, wires);
        return contents;
    }
}

