/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.util.Cache;
import java.util.Comparator;
import java.util.List;

public class Location
implements Comparable<Location> {
    private static final Cache cache = new Cache();
    private final int hashCode;
    public final int x;
    public final int y;
    private final boolean hasToSnap;
    public static final Comparator<At> CompareHorizontal = new Horizontal();
    public static final Comparator<At> CompareVertical = new Vertical();

    public static Location create(int x, int y, boolean hasToSnap) {
        Location loc;
        int yRounded;
        int xRounded = hasToSnap ? Math.round(x / 5) * 5 : x;
        int hashCode = 31 * xRounded + (yRounded = hasToSnap ? Math.round(y / 5) * 5 : y);
        Object ret = cache.get(hashCode);
        if (ret != null) {
            loc = (Location)ret;
            if (loc.x == xRounded && loc.y == yRounded) {
                return loc;
            }
        }
        loc = new Location(hashCode, xRounded, yRounded, hasToSnap);
        cache.put(hashCode, loc);
        return loc;
    }

    public static Location parse(String value) {
        int comma;
        String base = value;
        if ((value = value.trim()).charAt(0) == '(') {
            int len = value.length();
            if (value.charAt(len - 1) != ')') {
                throw new NumberFormatException("invalid point '" + base + "'");
            }
            value = value.substring(1, len - 1);
        }
        if ((comma = (value = value.trim()).indexOf(44)) < 0 && (comma = value.indexOf(32)) < 0) {
            throw new NumberFormatException("invalid point '" + base + "'");
        }
        int x = Integer.parseInt(value.substring(0, comma).trim());
        int y = Integer.parseInt(value.substring(comma + 1).trim());
        return Location.create(x, y, true);
    }

    private Location(int hashCode, int x, int y, boolean hasToSnap) {
        this.hashCode = hashCode;
        this.hasToSnap = hasToSnap;
        this.x = x;
        this.y = y;
    }

    @Override
    public int compareTo(Location other) {
        return this.x != other.x ? this.x - other.x : this.y - other.y;
    }

    public boolean equals(Object otherObj) {
        boolean bl;
        if (otherObj instanceof Location) {
            Location other = (Location)otherObj;
            bl = this.x == other.x && this.y == other.y;
        } else {
            bl = false;
        }
        return bl;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int manhattanDistanceTo(int x, int y) {
        return Math.abs(x - this.x) + Math.abs(y - this.y);
    }

    public int manhattanDistanceTo(Location o) {
        return Math.abs(o.x - this.x) + Math.abs(o.y - this.y);
    }

    public Location rotate(Direction from, Direction to, int xc, int yc) {
        int degrees;
        for (degrees = to.toDegrees() - from.toDegrees(); degrees >= 360; degrees -= 360) {
        }
        while (degrees < 0) {
            degrees += 360;
        }
        int dx = this.x - xc;
        int dy = this.y - yc;
        if (degrees == 90) {
            return Location.create(xc + dy, yc - dx, this.hasToSnap);
        }
        if (degrees == 180) {
            return Location.create(xc - dx, yc - dy, this.hasToSnap);
        }
        if (degrees == 270) {
            return Location.create(xc - dy, yc + dx, this.hasToSnap);
        }
        return this;
    }

    public String toString() {
        return String.format("(%d,%d)", this.x, this.y);
    }

    public Location translate(Direction dir, int dist) {
        return this.translate(dir, dist, 0);
    }

    public Location translate(Direction dir, int dist, int right) {
        if (dist == 0 && right == 0) {
            return this;
        }
        if (dir == Direction.EAST) {
            return Location.create(this.x + dist, this.y + right, this.hasToSnap);
        }
        if (dir == Direction.WEST) {
            return Location.create(this.x - dist, this.y - right, this.hasToSnap);
        }
        if (dir == Direction.SOUTH) {
            return Location.create(this.x - right, this.y + dist, this.hasToSnap);
        }
        if (dir == Direction.NORTH) {
            return Location.create(this.x + right, this.y - dist, this.hasToSnap);
        }
        return Location.create(this.x + dist, this.y + right, this.hasToSnap);
    }

    public Location translate(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return this;
        }
        return Location.create(this.x + dx, this.y + dy, this.hasToSnap);
    }

    public static <T extends At> void sortHorizontal(List<T> list) {
        list.sort(CompareHorizontal);
    }

    public static <T extends At> void sortVertical(List<T> list) {
        list.sort(CompareVertical);
    }

    private static class Horizontal
    implements Comparator<At> {
        private Horizontal() {
        }

        @Override
        public int compare(At a, At b) {
            Location aloc = a.getLocation();
            Location bloc = b.getLocation();
            if (aloc.x != bloc.x) {
                return aloc.x - bloc.x;
            }
            if (aloc.y != bloc.y) {
                return aloc.y - bloc.y;
            }
            return a.hashCode() - b.hashCode();
        }
    }

    private static class Vertical
    implements Comparator<At> {
        private Vertical() {
        }

        @Override
        public int compare(At a, At b) {
            Location aloc = a.getLocation();
            Location bloc = b.getLocation();
            if (aloc.y != bloc.y) {
                return aloc.y - bloc.y;
            }
            if (aloc.x != bloc.x) {
                return aloc.x - bloc.x;
            }
            return a.hashCode() - b.hashCode();
        }
    }

    public static interface At {
        public Location getLocation();
    }
}

