/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.appear.AppearanceElement;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AppearancePort
extends AppearanceElement {
    private static final int INPUT_RADIUS = 4;
    private static final int OUTPUT_RADIUS = 5;
    private static final int MINOR_RADIUS = 2;
    public static final Color COLOR = Color.BLUE;
    private Instance pin;

    public AppearancePort(Location location, Instance pin) {
        super(location);
        this.pin = pin;
    }

    public static boolean isInputAppearance(int radius) {
        return radius == 4;
    }

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        return this.isInput() ? this.getBounds().contains(loc) : super.isInCircle(loc, 5);
    }

    @Override
    public Bounds getBounds() {
        int r = this.isInput() ? 4 : 5;
        return super.getBounds(r);
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("circuitPort");
    }

    @Override
    public String getDisplayNameAndLabel() {
        String label = this.pin.getAttributeValue(StdAttr.LABEL);
        return label != null && label.length() > 0 ? String.format("%s \"%s\"", this.getDisplayName(), label) : this.getDisplayName();
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        Location loc = this.getLocation();
        int r = this.isInput() ? 4 : 5;
        return UnmodifiableList.create(new Handle[]{new Handle(this, loc.translate(-r, -r)), new Handle(this, loc.translate(r, -r)), new Handle(this, loc.translate(r, r)), new Handle(this, loc.translate(-r, r))});
    }

    public Instance getPin() {
        return this.pin;
    }

    private boolean isInput() {
        Instance p = this.pin;
        return p == null || Pin.FACTORY.isInputPin(p);
    }

    @Override
    public boolean matches(CanvasObject other) {
        if (other instanceof AppearancePort) {
            AppearancePort that = (AppearancePort)other;
            return this.matches(that) && this.pin == that.pin;
        }
        return false;
    }

    @Override
    public int matchesHashCode() {
        return super.matchesHashCode() + this.pin.hashCode();
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        Location location = this.getLocation();
        int x = location.getX();
        int y = location.getY();
        g.setColor(COLOR);
        if (this.isInput()) {
            int r = 4;
            g.drawRect(x - 4, y - 4, 8, 8);
        } else {
            int r = 5;
            g.drawOval(x - 5, y - 5, 10, 10);
        }
        g.fillOval(x - 2, y - 2, 4, 4);
    }

    void setPin(Instance value) {
        this.pin = value;
    }

    @Override
    public Element toSvgElement(Document doc) {
        Location loc = this.getLocation();
        Location pinLoc = this.pin.getLocation();
        Element ret = doc.createElement("circ-port");
        ret.setAttribute("x", Integer.toString(loc.getX()));
        ret.setAttribute("y", Integer.toString(loc.getY()));
        ret.setAttribute("dir", this.isInput() ? "in" : "out");
        ret.setAttribute("pin", String.format("%d,%d", pinLoc.getX(), pinLoc.getY()));
        return ret;
    }
}

