/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import kong.unirest.core.GetRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.JsonNode;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestException;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAccessDoi
implements FulltextFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FulltextFetcher.class);
    private static final String API_URL = "https://api.oadoi.org/v2/";

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        Objects.requireNonNull(entry);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (!doi.isPresent()) {
            return Optional.empty();
        }
        try {
            return this.findFullText((DOI)doi.get());
        }
        catch (UnirestException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.META_SEARCH;
    }

    public Optional<URL> findFullText(DOI doi) throws UnirestException {
        HttpResponse request = ((GetRequest)Unirest.get((String)(API_URL + doi.getDOI() + "?email=developers@jabref.org")).header("accept", "application/json")).asJson();
        return Optional.of(request).map(HttpResponse::getBody).filter(Objects::nonNull).map(JsonNode::getObject).filter(Objects::nonNull).map(root -> root.optJSONObject("best_oa_location")).filter(Objects::nonNull).map(location -> location.optString("url")).flatMap(url -> {
            try {
                return Optional.of(new URL((String)url));
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Could not determine URL to fetch full text from", (Throwable)e);
                return Optional.empty();
            }
        });
    }
}

