/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.util.Collection;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.cleanup.NormalizeWhitespacesCleanup;
import org.jabref.logic.importer.ImportCleanupBiblatex;
import org.jabref.logic.importer.ImportCleanupBibtex;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jspecify.annotations.NonNull;

public abstract class ImportCleanup {
    private final NormalizeWhitespacesCleanup normalizeWhitespacesCleanup;

    protected ImportCleanup(FieldPreferences fieldPreferences) {
        this.normalizeWhitespacesCleanup = new NormalizeWhitespacesCleanup(fieldPreferences);
    }

    public static ImportCleanup targeting(BibDatabaseMode mode, @NonNull FieldPreferences fieldPreferences) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case BibDatabaseMode.BIBTEX -> new ImportCleanupBibtex(fieldPreferences);
            case BibDatabaseMode.BIBLATEX -> new ImportCleanupBiblatex(fieldPreferences);
        };
    }

    public BibEntry doPostCleanup(BibEntry entry) {
        this.normalizeWhitespacesCleanup.cleanup(entry);
        return entry;
    }

    public void doPostCleanup(Collection<BibEntry> entries) {
        entries.forEach(this::doPostCleanup);
    }
}

