/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.crawler;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jabref.logic.crawler.StudyCatalogToFetcherConverter;
import org.jabref.logic.crawler.StudyFetcher;
import org.jabref.logic.crawler.StudyRepository;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.git.SlrGitHandler;
import org.jabref.logic.importer.ParseException;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.study.QueryResult;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class Crawler {
    public static final String FILENAME_STUDY_RESULT_BIB = "studyResult.bib";
    private final StudyRepository studyRepository;
    private final StudyFetcher studyFetcher;

    public Crawler(Path studyRepositoryRoot, SlrGitHandler gitHandler, PreferencesService preferencesService, BibEntryTypesManager bibEntryTypesManager, FileUpdateMonitor fileUpdateMonitor) throws IllegalArgumentException, IOException, ParseException {
        this.studyRepository = new StudyRepository(studyRepositoryRoot, gitHandler, preferencesService, fileUpdateMonitor, bibEntryTypesManager);
        StudyCatalogToFetcherConverter studyCatalogToFetcherConverter = new StudyCatalogToFetcherConverter(this.studyRepository.getActiveLibraryEntries(), preferencesService.getImportFormatPreferences(), preferencesService.getImporterPreferences());
        this.studyFetcher = new StudyFetcher(studyCatalogToFetcherConverter.getActiveFetchers(), this.studyRepository.getSearchQueryStrings());
    }

    public void performCrawl() throws IOException, GitAPIException, SaveException {
        List<QueryResult> results = this.studyFetcher.crawl();
        this.studyRepository.persist(results);
    }
}

