/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Date;
import org.jabref.model.entry.EntryConverter;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.strings.StringUtil;

public class ConvertToBiblatexCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (Map.Entry<Field, Field> alias : EntryConverter.FIELD_ALIASES_BIBTEX_TO_BIBLATEX.entrySet()) {
            Field oldField = alias.getKey();
            Field newField = alias.getValue();
            entry.getField(oldField).ifPresent(oldValue -> {
                if (!oldValue.isEmpty() && !entry.getField(newField).isPresent()) {
                    entry.setField(newField, (String)oldValue).ifPresent(changes::add);
                    entry.clearField(oldField).ifPresent(changes::add);
                }
            });
        }
        if (StringUtil.isBlank(entry.getField(StandardField.DATE))) {
            entry.getFieldOrAlias(StandardField.DATE).ifPresent(newDate -> {
                entry.setField(StandardField.DATE, (String)newDate).ifPresent(changes::add);
                entry.clearField(StandardField.YEAR).ifPresent(changes::add);
                entry.clearField(StandardField.MONTH).ifPresent(changes::add);
            });
        } else {
            entry.getFieldOrAlias(StandardField.DATE).ifPresent(date -> {
                Optional<Date> newDate = Date.parse(date);
                Optional<Date> checkDate = Date.parse(entry.getFieldOrAlias(StandardField.YEAR), entry.getFieldOrAlias(StandardField.MONTH), Optional.empty());
                if (checkDate.equals(newDate)) {
                    entry.clearField(StandardField.YEAR).ifPresent(changes::add);
                    entry.clearField(StandardField.MONTH).ifPresent(changes::add);
                }
            });
        }
        return changes;
    }
}

