/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.bibtex.FieldWriter;
import org.jabref.logic.bibtex.InvalidFieldValueException;
import org.jabref.logic.bst.BstBaseVisitor;
import org.jabref.logic.bst.BstEntry;
import org.jabref.logic.bst.BstParser;
import org.jabref.logic.bst.BstVM;
import org.jabref.logic.bst.BstVMContext;
import org.jabref.logic.bst.BstVMException;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BstVMVisitor
extends BstBaseVisitor<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BstVMVisitor.class);
    private final BstVMContext bstVMContext;
    private final StringBuilder bbl;
    private BstEntry selectedBstEntry = null;

    public BstVMVisitor(BstVMContext bstVMContext, StringBuilder bbl) {
        this.bstVMContext = bstVMContext;
        this.bbl = bbl;
    }

    @Override
    public Integer visitStringsCommand(BstParser.StringsCommandContext ctx) {
        if (ctx.ids.identifier().size() > 20) {
            throw new BstVMException("Strings limit reached");
        }
        for (BstParser.IdentifierContext identifierContext : ctx.ids.identifier()) {
            this.bstVMContext.strings().put(identifierContext.getText(), null);
        }
        return BstVM.TRUE;
    }

    @Override
    public Integer visitIntegersCommand(BstParser.IntegersCommandContext ctx) {
        for (BstParser.IdentifierContext identifierContext : ctx.ids.identifier()) {
            this.bstVMContext.integers().put(identifierContext.getText(), 0);
        }
        return BstVM.TRUE;
    }

    @Override
    public Integer visitFunctionCommand(BstParser.FunctionCommandContext ctx) {
        String name = ctx.id.getText();
        LOGGER.trace("Function: {}", (Object)name);
        this.bstVMContext.functions().put(name, (visitor, functionContext) -> visitor.visit((ParseTree)ctx.function));
        return BstVM.TRUE;
    }

    @Override
    public Integer visitMacroCommand(BstParser.MacroCommandContext ctx) {
        String replacement = ctx.repl.getText().substring(1, ctx.repl.getText().length() - 1);
        this.bstVMContext.functions().put(ctx.id.getText(), (visitor, functionContext) -> this.bstVMContext.stack().push(replacement));
        return BstVM.TRUE;
    }

    @Override
    public Integer visitReadCommand(BstParser.ReadCommandContext ctx) {
        FieldWriter fieldWriter = new FieldWriter(new FieldPreferences(true, List.of(StandardField.MONTH), Collections.emptyList()));
        for (BstEntry e : this.bstVMContext.entries()) {
            for (Map.Entry<String, String> mEntry : e.fields.entrySet()) {
                Field field = FieldFactory.parseField(mEntry.getKey());
                String fieldValue = e.entry.getResolvedFieldOrAlias(field, this.bstVMContext.bibDatabase()).map(content -> {
                    try {
                        String result = fieldWriter.write(field, (String)content);
                        if (result.startsWith("{")) {
                            return result.substring(1, result.length() - 1);
                        }
                        if (field == StandardField.MONTH) {
                            return Month.parse(result).map(Month::getFullName).orElse(result);
                        }
                        return result;
                    }
                    catch (InvalidFieldValueException invalidFieldValueException) {
                        return content;
                    }
                }).orElse(null);
                mEntry.setValue(fieldValue);
            }
        }
        for (BstEntry e : this.bstVMContext.entries()) {
            if (e.fields.containsKey(StandardField.CROSSREF.getName())) continue;
            e.fields.put(StandardField.CROSSREF.getName(), null);
        }
        return BstVM.TRUE;
    }

    @Override
    public Integer visitExecuteCommand(BstParser.ExecuteCommandContext ctx) {
        this.selectedBstEntry = null;
        BstParser.BstFunctionContext bstFunction = ctx.bstFunction();
        String name = bstFunction.getText();
        LOGGER.trace("Executing function {}", (Object)name);
        this.visit((ParseTree)bstFunction);
        LOGGER.trace("Finished executing function {}", (Object)name);
        return BstVM.TRUE;
    }

    @Override
    public Integer visitIterateCommand(BstParser.IterateCommandContext ctx) {
        String name = ctx.bstFunction().getText();
        LOGGER.trace("Executing {}", (Object)name);
        Iterator<BstEntry> iterator = this.bstVMContext.entries().iterator();
        while (iterator.hasNext()) {
            BstEntry entry;
            this.selectedBstEntry = entry = iterator.next();
            this.visit((ParseTree)ctx.bstFunction());
        }
        LOGGER.trace("Finished executing {}", (Object)name);
        return BstVM.TRUE;
    }

    @Override
    public Integer visitReverseCommand(BstParser.ReverseCommandContext ctx) {
        ListIterator<BstEntry> i = this.bstVMContext.entries().listIterator(this.bstVMContext.entries().size());
        while (i.hasPrevious()) {
            this.selectedBstEntry = i.previous();
            this.visit((ParseTree)ctx.bstFunction());
        }
        return BstVM.TRUE;
    }

    @Override
    public Integer visitEntryCommand(BstParser.EntryCommandContext ctx) {
        BstParser.IdListOptContext entryFields = ctx.idListOpt(0);
        for (BstParser.IdentifierContext identifierContext : entryFields.identifier()) {
            for (BstEntry bstEntry : this.bstVMContext.entries()) {
                bstEntry.fields.put(identifierContext.getText(), null);
            }
        }
        BstParser.IdListOptContext entryIntegers = ctx.idListOpt(1);
        for (BstParser.IdentifierContext identifierContext : entryIntegers.identifier()) {
            for (BstEntry entry : this.bstVMContext.entries()) {
                entry.localIntegers.put(identifierContext.getText(), 0);
            }
        }
        BstParser.IdListOptContext idListOptContext = ctx.idListOpt(2);
        for (BstParser.IdentifierContext identifierContext : idListOptContext.identifier()) {
            for (BstEntry entry : this.bstVMContext.entries()) {
                entry.localStrings.put(identifierContext.getText(), null);
            }
        }
        for (BstEntry bstEntry : this.bstVMContext.entries()) {
            bstEntry.localStrings.put("sort.key$", null);
        }
        return BstVM.TRUE;
    }

    @Override
    public Integer visitSortCommand(BstParser.SortCommandContext ctx) {
        this.bstVMContext.entries().sort(Comparator.comparing(o -> o.localStrings.get("sort.key$")));
        return BstVM.TRUE;
    }

    @Override
    public Integer visitIdentifier(BstParser.IdentifierContext ctx) {
        String name = ctx.IDENTIFIER().getText();
        LOGGER.trace("Identifier: {}", (Object)name);
        this.resolveIdentifier(name, ctx);
        return BstVM.TRUE;
    }

    protected void resolveIdentifier(String name, ParserRuleContext ctx) {
        LOGGER.trace("Resolving name {} at resolveIdentifier", (Object)name);
        LOGGER.trace("Stack: {}", this.bstVMContext.stack());
        if (this.selectedBstEntry != null) {
            LOGGER.trace("selectedBstEntry is available");
            if (this.selectedBstEntry.fields.containsKey(name)) {
                String value = this.selectedBstEntry.fields.get(name);
                LOGGER.trace("entry field {}={}", (Object)name, (Object)value);
                this.bstVMContext.stack().push(value);
                return;
            }
            if (this.selectedBstEntry.localStrings.containsKey(name)) {
                String value = this.selectedBstEntry.localStrings.get(name);
                LOGGER.trace("entry local string {}={}", (Object)name, (Object)value);
                this.bstVMContext.stack().push(value);
                return;
            }
            if (this.selectedBstEntry.localIntegers.containsKey(name)) {
                Integer value = this.selectedBstEntry.localIntegers.get(name);
                LOGGER.trace("entry local integer {}={}", (Object)name, (Object)value);
                this.bstVMContext.stack().push(value);
                return;
            }
        }
        if (this.bstVMContext.strings().containsKey(name)) {
            String value = this.bstVMContext.strings().get(name);
            LOGGER.trace("global string {}={}", (Object)name, (Object)value);
            this.bstVMContext.stack().push(value);
            return;
        }
        if (this.bstVMContext.integers().containsKey(name)) {
            Integer value = this.bstVMContext.integers().get(name);
            LOGGER.trace("global integer {}={}", (Object)name, (Object)value);
            this.bstVMContext.stack().push(value);
            return;
        }
        if (this.bstVMContext.functions().containsKey(name)) {
            LOGGER.trace("function {}", (Object)name);
            this.bstVMContext.functions().get(name).execute(this, ctx, this.selectedBstEntry);
            return;
        }
        LOGGER.warn("No matching identifier found: {}", (Object)name);
        throw new BstVMException("No matching identifier found: " + name);
    }

    @Override
    public Integer visitBstFunction(BstParser.BstFunctionContext ctx) {
        String name = ctx.getChild(0).getText();
        LOGGER.trace("Resolving name {} at visitBstFunction", (Object)name);
        this.resolveIdentifier(name, ctx);
        return BstVM.TRUE;
    }

    @Override
    public Integer visitStackitem(BstParser.StackitemContext ctx) {
        for (ParseTree childNode : ctx.children) {
            try {
                if (childNode instanceof TerminalNode) {
                    TerminalNode token = (TerminalNode)childNode;
                    switch (token.getSymbol().getType()) {
                        case 23: {
                            String s = token.getText();
                            this.bstVMContext.stack().push(s.substring(1, s.length() - 1));
                            break;
                        }
                        case 21: {
                            this.bstVMContext.stack().push(Integer.parseInt(token.getText().substring(1)));
                            break;
                        }
                        case 22: {
                            this.bstVMContext.stack().push(new Identifier(token.getText().substring(1)));
                        }
                    }
                    continue;
                }
                if (childNode instanceof BstParser.StackContext) {
                    this.bstVMContext.stack().push(childNode);
                    continue;
                }
                this.visit(childNode);
            }
            catch (BstVMException e) {
                this.bstVMContext.path().ifPresentOrElse(path -> LOGGER.error("{} ({})", (Object)e.getMessage(), path), () -> LOGGER.error(e.getMessage()));
                throw e;
            }
        }
        return BstVM.TRUE;
    }

    public record Identifier(String name) {
    }
}

