/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.model.entry.BibEntry;

public class CustomLocalDragboard {
    private static final Class<List<BibEntry>> BIB_ENTRIES = List.class;
    private final Map<Class<?>, Object> contents = new HashMap();

    public <T> void putValue(Class<T> type, T value) {
        this.clearAll();
        this.contents.put(type, type.cast(value));
    }

    public <T> T getValue(Class<T> type) {
        return type.cast(this.contents.get(type));
    }

    public boolean hasType(Class<?> type) {
        return this.contents.containsKey(type);
    }

    public void clear(Class<?> type) {
        this.contents.remove(type);
    }

    public void clearAll() {
        this.contents.clear();
    }

    public void putBibEntries(List<BibEntry> entries) {
        this.putValue(BIB_ENTRIES, entries);
    }

    public List<BibEntry> getBibEntries() {
        if (this.hasBibEntries()) {
            return this.getValue(BIB_ENTRIES);
        }
        return Collections.emptyList();
    }

    public boolean hasBibEntries() {
        return this.hasType(BIB_ENTRIES);
    }

    public void putPreviewLayouts(List<PreviewLayout> previewLayouts) {
        this.putValue(DragAndDropDataFormats.PREVIEWLAYOUT_LIST_CLASS, previewLayouts);
    }

    public List<PreviewLayout> getPreviewLayouts() {
        if (this.hasType(DragAndDropDataFormats.PREVIEWLAYOUT_LIST_CLASS)) {
            return this.getValue(DragAndDropDataFormats.PREVIEWLAYOUT_LIST_CLASS);
        }
        return Collections.emptyList();
    }
}

