/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.sidepane;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.scene.layout.VBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.sidepane.SidePaneComponent;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.gui.sidepane.SidePaneViewModel;
import org.jabref.gui.sidepane.TogglePaneAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class SidePane
extends VBox {
    private final SidePaneViewModel viewModel;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final Map<SidePaneType, BooleanBinding> visibleBindings = new HashMap<SidePaneType, BooleanBinding>();

    public SidePane(LibraryTabContainer tabContainer, PreferencesService preferencesService, JournalAbbreviationRepository abbreviationRepository, TaskExecutor taskExecutor, DialogService dialogService, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager, ClipBoardManager clipBoardManager, UndoManager undoManager) {
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.viewModel = new SidePaneViewModel(tabContainer, preferencesService, abbreviationRepository, stateManager, taskExecutor, dialogService, fileUpdateMonitor, entryTypesManager, clipBoardManager, undoManager);
        stateManager.getVisibleSidePaneComponents().addListener(c -> this.updateView());
        this.updateView();
    }

    private void updateView() {
        this.getChildren().clear();
        for (SidePaneType type : this.stateManager.getVisibleSidePaneComponents()) {
            SidePaneComponent view = this.viewModel.getSidePaneComponent(type);
            this.getChildren().add((Object)view);
        }
    }

    public BooleanBinding paneVisibleBinding(SidePaneType pane) {
        BooleanBinding visibility = Bindings.createBooleanBinding(() -> this.stateManager.getVisibleSidePaneComponents().contains((Object)pane), (Observable[])new Observable[]{this.stateManager.getVisibleSidePaneComponents()});
        this.visibleBindings.put(pane, visibility);
        return visibility;
    }

    public SimpleCommand getToggleCommandFor(SidePaneType sidePane) {
        return new TogglePaneAction(this.stateManager, sidePane, this.preferencesService.getSidePanePreferences());
    }

    public SidePaneComponent getSidePaneComponent(SidePaneType type) {
        return this.viewModel.getSidePaneComponent(type);
    }
}

