/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.gui.DialogService;
import org.jabref.gui.openoffice.Bootstrap;
import org.jabref.gui.openoffice.OOError;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.NoDocumentFoundException;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoTextDocument;
import org.jabref.model.openoffice.util.OOResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOBibBaseConnect {
    private static final Logger LOGGER = LoggerFactory.getLogger(OOBibBaseConnect.class);
    private final DialogService dialogService;
    private final XDesktop xDesktop;
    private XTextDocument xTextDocument;

    public OOBibBaseConnect(Path loPath, DialogService dialogService) throws BootstrapException, CreationException {
        this.dialogService = dialogService;
        this.xDesktop = this.simpleBootstrap(loPath);
    }

    private XDesktop simpleBootstrap(Path loPath) throws CreationException, BootstrapException {
        Object desktop;
        XComponentContext context = Bootstrap.bootstrap(loPath);
        XMultiComponentFactory sem = context.getServiceManager();
        try {
            desktop = sem.createInstanceWithContext("com.sun.star.frame.Desktop", context);
        }
        catch (com.sun.star.uno.Exception e) {
            throw new CreationException(e.getMessage());
        }
        return UnoCast.cast(XDesktop.class, desktop).get();
    }

    public static void closeOfficeConnection() {
        try {
            XBridgeFactory bridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)Bootstrap.createSimpleServiceManager().createInstance("com.sun.star.bridge.BridgeFactory"));
            if (bridgeFactory != null) {
                for (XBridge bridge : bridgeFactory.getExistingBridges()) {
                    ((XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)bridge)).dispose();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Exception disposing office process connection bridge", (Throwable)ex);
        }
    }

    private static List<XTextDocument> getTextDocuments(XDesktop desktop) throws NoSuchElementException, WrappedTargetException {
        ArrayList<XTextDocument> result = new ArrayList<XTextDocument>();
        XEnumerationAccess enumAccess = desktop.getComponents();
        XEnumeration compEnum = enumAccess.createEnumeration();
        while (compEnum.hasMoreElements()) {
            Object next = compEnum.nextElement();
            XComponent comp = UnoCast.cast(XComponent.class, next).get();
            Optional<XTextDocument> doc = UnoCast.cast(XTextDocument.class, comp);
            doc.ifPresent(result::add);
        }
        return result;
    }

    private static XTextDocument selectDocumentDialog(List<XTextDocument> list, DialogService dialogService) {
        class DocumentTitleViewModel {
            private final XTextDocument xTextDocument;
            private final String description;

            public DocumentTitleViewModel(XTextDocument xTextDocument) {
                this.xTextDocument = xTextDocument;
                this.description = UnoTextDocument.getFrameTitle(xTextDocument).orElse("");
            }

            public XTextDocument getXtextDocument() {
                return this.xTextDocument;
            }

            public String toString() {
                return this.description;
            }
        }
        List viewModel = list.stream().map(x$0 -> new DocumentTitleViewModel((XTextDocument)x$0)).collect(Collectors.toList());
        Optional<DocumentTitleViewModel> selectedDocument = dialogService.showChoiceDialogAndWait(Localization.lang("Select document", new Object[0]), Localization.lang("Found documents:", new Object[0]), Localization.lang("Use selected document", new Object[0]), viewModel);
        return selectedDocument.map(DocumentTitleViewModel::getXtextDocument).orElse(null);
    }

    public void selectDocument(boolean autoSelectForSingle) throws NoDocumentFoundException, NoSuchElementException, WrappedTargetException {
        List<XTextDocument> textDocumentList = OOBibBaseConnect.getTextDocuments(this.xDesktop);
        if (textDocumentList.isEmpty()) {
            throw new NoDocumentFoundException("No Writer documents found");
        }
        XTextDocument selected = textDocumentList.size() == 1 && autoSelectForSingle ? textDocumentList.getFirst() : OOBibBaseConnect.selectDocumentDialog(textDocumentList, this.dialogService);
        if (selected == null) {
            return;
        }
        this.xTextDocument = selected;
    }

    private void forgetDocument() {
        this.xTextDocument = null;
    }

    public boolean isConnectedToDocument() {
        return this.xTextDocument != null;
    }

    public boolean isDocumentConnectionMissing() {
        XTextDocument doc = this.xTextDocument;
        if (doc == null) {
            return true;
        }
        if (UnoTextDocument.isDocumentConnectionMissing(doc)) {
            this.forgetDocument();
            return true;
        }
        return false;
    }

    public XTextDocument getXTextDocumentOrThrow() throws NoDocumentException {
        if (this.isDocumentConnectionMissing()) {
            throw new NoDocumentException("Not connected to document");
        }
        return this.xTextDocument;
    }

    public OOResult<XTextDocument, OOError> getXTextDocument() {
        if (this.isDocumentConnectionMissing()) {
            return OOResult.error(OOError.from(new NoDocumentException()));
        }
        return OOResult.ok(this.xTextDocument);
    }

    public Optional<String> getCurrentDocumentTitle() {
        if (this.isDocumentConnectionMissing()) {
            return Optional.empty();
        }
        return UnoTextDocument.getFrameTitle(this.xTextDocument);
    }
}

