/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.cell;

import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.fieldeditors.URLUtil;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.mergeentries.newmergedialog.cell.CopyFieldValueCommand;
import org.jabref.gui.mergeentries.newmergedialog.cell.FieldValueCellViewModel;
import org.jabref.gui.mergeentries.newmergedialog.cell.OpenExternalLinkAction;
import org.jabref.gui.mergeentries.newmergedialog.cell.ThreeWayMergeCell;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign2.MaterialDesignC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldValueCell
extends ThreeWayMergeCell
implements Toggle {
    public static final Logger LOGGER = LoggerFactory.getLogger(FieldValueCell.class);
    public static final String DEFAULT_STYLE_CLASS = "merge-field-value";
    public static final String SELECTION_BOX_STYLE_CLASS = "selection-box";
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private final PreferencesService preferencesService;
    private final ActionFactory factory;
    private final StyleClassedTextArea label = new StyleClassedTextArea();
    private final VirtualizedScrollPane<StyleClassedTextArea> scrollPane = new VirtualizedScrollPane((Region)this.label);
    HBox labelBox = new HBox(new Node[]{this.scrollPane});
    private final HBox selectionBox = new HBox();
    private final HBox actionsContainer = new HBox();
    private final FieldValueCellViewModel viewModel;

    public FieldValueCell(String text, int rowIndex, PreferencesService preferencesService) {
        super(text, rowIndex);
        this.preferencesService = preferencesService;
        this.factory = new ActionFactory();
        this.viewModel = new FieldValueCellViewModel(text);
        EasyBind.listen((ObservableValue)this.viewModel.selectedProperty(), (observable, old, isSelected) -> {
            this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, (boolean)isSelected);
            this.getToggleGroup().selectToggle((Toggle)this);
        });
        this.viewModel.fieldValueProperty().bind((ObservableValue)this.textProperty());
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.initializeScrollPane();
        this.initializeLabel();
        this.initializeSelectionBox();
        this.initializeActions();
        this.setOnMouseClicked(e -> {
            if (!this.isDisabled()) {
                this.setSelected(true);
            }
        });
        this.selectionBox.getChildren().addAll((Object[])new Node[]{this.labelBox, this.actionsContainer});
        this.getChildren().setAll((Object[])new Node[]{this.selectionBox});
    }

    private void initializeLabel() {
        this.label.setEditable(false);
        this.label.setBackground(Background.fill((Paint)Color.TRANSPARENT));
        EasyBind.subscribe((ObservableValue)this.textProperty(), arg_0 -> ((StyleClassedTextArea)this.label).replaceText(arg_0));
        this.label.setAutoHeight(true);
        this.label.setWrapText(true);
        this.label.setStyle("-fx-cursor: hand");
        this.preventTextSelectionViaMouseEvents();
        this.label.prefHeightProperty().bind((ObservableValue)this.label.totalHeightEstimateProperty().orElseConst((Object)-1.0));
        this.label.addEventFilter(ScrollEvent.SCROLL, e -> {
            e.consume();
            this.fireEvent((Event)e.copyFor(e.getSource(), (EventTarget)this));
        });
    }

    private void initializeActions() {
        this.actionsContainer.getChildren().setAll((Object[])new Node[]{this.createOpenLinkButton(), this.createCopyButton()});
        this.actionsContainer.setAlignment(Pos.TOP_CENTER);
        this.actionsContainer.setPrefWidth(28.0);
    }

    private void initializeSelectionBox() {
        this.selectionBox.getStyleClass().add((Object)SELECTION_BOX_STYLE_CLASS);
        HBox.setHgrow((Node)this.selectionBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.labelBox, (Priority)Priority.ALWAYS);
        this.labelBox.setPadding(new Insets(8.0));
        this.labelBox.setCursor(Cursor.HAND);
    }

    private Button createCopyButton() {
        FontIcon copyIcon = FontIcon.of((Ikon)MaterialDesignC.CONTENT_COPY);
        copyIcon.getStyleClass().add((Object)"action-icon");
        Button copyButton = this.factory.createIconButton(() -> Localization.lang("Copy", new Object[0]), (Command)new CopyFieldValueCommand(this.getText()));
        copyButton.setGraphic((Node)copyIcon);
        copyButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        copyButton.setMaxHeight(Double.MAX_VALUE);
        copyButton.visibleProperty().bind((ObservableValue)this.textProperty().isEmpty().not());
        return copyButton;
    }

    public Button createOpenLinkButton() {
        Node openLinkIcon = IconTheme.JabRefIcons.OPEN_LINK.getGraphicNode();
        openLinkIcon.getStyleClass().add((Object)"action-icon");
        Button openLinkButton = this.factory.createIconButton(() -> Localization.lang("Open Link", new Object[0]), (Command)new OpenExternalLinkAction(this.getText(), this.preferencesService.getFilePreferences()));
        openLinkButton.setGraphic(openLinkIcon);
        openLinkButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        openLinkButton.setMaxHeight(Double.MAX_VALUE);
        openLinkButton.visibleProperty().bind((ObservableValue)EasyBind.map((ObservableValue)this.textProperty(), input -> StringUtil.isNotBlank(input) && (URLUtil.isURL(input) || DOI.isValid(input))));
        return openLinkButton;
    }

    private void initializeScrollPane() {
        HBox.setHgrow(this.scrollPane, (Priority)Priority.ALWAYS);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
    }

    private void preventTextSelectionViaMouseEvents() {
        this.label.addEventFilter(MouseEvent.ANY, e -> {
            if (e.getEventType() == MouseEvent.MOUSE_DRAGGED || e.getEventType() == MouseEvent.DRAG_DETECTED || e.getEventType() == MouseEvent.MOUSE_ENTERED) {
                e.consume();
            } else if (e.getEventType() == MouseEvent.MOUSE_PRESSED && e.getClickCount() > 1) {
                e.consume();
            }
        });
    }

    public ToggleGroup getToggleGroup() {
        return this.viewModel.getToggleGroup();
    }

    public void setToggleGroup(ToggleGroup toggleGroup) {
        this.viewModel.setToggleGroup(toggleGroup);
    }

    public ObjectProperty<ToggleGroup> toggleGroupProperty() {
        return this.viewModel.toggleGroupProperty();
    }

    public boolean isSelected() {
        return this.viewModel.isSelected();
    }

    public void setSelected(boolean selected) {
        this.viewModel.setSelected(selected);
    }

    public BooleanProperty selectedProperty() {
        return this.viewModel.selectedProperty();
    }

    public StyleClassedTextArea getStyleClassedLabel() {
        return this.label;
    }
}

