/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import java.util.Arrays;
import java.util.List;
import javax.swing.undo.UndoManager;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.mergeentries.EntriesMergeResult;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableInsertEntries;
import org.jabref.gui.undo.UndoableRemoveEntries;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class MergeTwoEntriesAction
extends SimpleCommand {
    private final EntriesMergeResult entriesMergeResult;
    private final StateManager stateManager;
    private final UndoManager undoManager;

    public MergeTwoEntriesAction(EntriesMergeResult entriesMergeResult, StateManager stateManager, UndoManager undoManager) {
        this.entriesMergeResult = entriesMergeResult;
        this.stateManager = stateManager;
        this.undoManager = undoManager;
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        BibDatabase database = this.stateManager.getActiveDatabase().get().getDatabase();
        List<BibEntry> entriesToRemove = Arrays.asList(this.entriesMergeResult.originalLeftEntry(), this.entriesMergeResult.originalRightEntry());
        database.insertEntry(this.entriesMergeResult.mergedEntry());
        database.removeEntries(entriesToRemove);
        NamedCompound ce = new NamedCompound(Localization.lang("Merge entries", new Object[0]));
        ce.addEdit(new UndoableInsertEntries(this.stateManager.getActiveDatabase().get().getDatabase(), this.entriesMergeResult.mergedEntry()));
        ce.addEdit(new UndoableRemoveEntries(database, entriesToRemove));
        ce.end();
        this.undoManager.addEdit(ce);
    }
}

