/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable.columns;

import com.google.common.collect.MoreCollectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Tooltip;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.MainTableTooltip;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.comparator.NumericFieldComparator;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.UnknownField;

public class FieldColumn
extends MainTableColumn<String> {
    private final OrFields fields;
    private final MainTableTooltip tooltip;

    public FieldColumn(MainTableColumnModel model, MainTableTooltip tooltip) {
        super(model);
        Field field;
        this.fields = FieldFactory.parseOrFields(model.getQualifier());
        this.tooltip = tooltip;
        this.setText(this.getDisplayName());
        this.setCellValueFactory(param -> this.getFieldValue((BibEntryTableViewModel)param.getValue()));
        new ValueTableCellFactory().withText(text -> text).graphicTooltip(this::createTooltip).install(this);
        if (this.fields.hasExactlyOne() && ((field = (Field)this.fields.getFields().stream().collect(MoreCollectors.onlyElement())) instanceof UnknownField || field.isNumeric())) {
            this.setComparator(new NumericFieldComparator());
        }
        this.setSortable(true);
    }

    @Override
    public String getDisplayName() {
        return this.fields.getDisplayName();
    }

    private ObservableValue<String> getFieldValue(BibEntryTableViewModel entry) {
        if (this.fields.isEmpty()) {
            return null;
        }
        return entry.getFields(this.fields);
    }

    private Tooltip createTooltip(BibEntryTableViewModel entry, String fieldValue) {
        return this.tooltip.createTooltip(entry.getEntry(), fieldValue);
    }
}

