/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.linkedfile;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

public class AttachFileFromURLAction
extends SimpleCommand {
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final TaskExecutor taskExecutor;

    public AttachFileFromURLAction(DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor, PreferencesService preferencesService) {
        this.stateManager = stateManager;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(1, stateManager));
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            this.dialogService.notify(Localization.lang("This operation requires an open library.", new Object[0]));
            return;
        }
        if (this.stateManager.getSelectedEntries().size() != 1) {
            this.dialogService.notify(Localization.lang("This operation requires exactly one item to be selected.", new Object[0]));
            return;
        }
        BibDatabaseContext databaseContext = this.stateManager.getActiveDatabase().get();
        BibEntry entry = (BibEntry)this.stateManager.getSelectedEntries().getFirst();
        Optional<String> urlforDownload = AttachFileFromURLAction.getUrlForDownloadFromClipBoardOrEntry(this.dialogService, entry);
        if (urlforDownload.isEmpty()) {
            return;
        }
        try {
            URL url = new URL(urlforDownload.get());
            LinkedFileViewModel onlineFile = new LinkedFileViewModel(new LinkedFile(url, ""), entry, databaseContext, this.taskExecutor, this.dialogService, this.preferencesService);
            onlineFile.download(true);
        }
        catch (MalformedURLException exception) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Invalid URL", new Object[0]), exception);
        }
    }

    public static Optional<String> getUrlForDownloadFromClipBoardOrEntry(DialogService dialogService, BibEntry entry) {
        String clipText = ClipBoardManager.getContents();
        String urlField = entry.getField(StandardField.URL).orElse("");
        Optional<String> urlText = clipText.startsWith("http://") || clipText.startsWith("https://") || clipText.startsWith("ftp://") ? dialogService.showInputDialogWithDefaultAndWait(Localization.lang("Download file", new Object[0]), Localization.lang("Enter URL to download", new Object[0]), clipText) : (urlField.startsWith("http://") || urlField.startsWith("https://") || urlField.startsWith("ftp://") ? dialogService.showInputDialogWithDefaultAndWait(Localization.lang("Download file", new Object[0]), Localization.lang("Enter URL to download", new Object[0]), urlField) : dialogService.showInputDialogAndWait(Localization.lang("Download file", new Object[0]), Localization.lang("Enter URL to download", new Object[0])));
        return urlText;
    }
}

