/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.util.Optional;
import org.controlsfx.control.PopOver;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.externalfiles.ImportHandler;
import org.jabref.gui.importer.NewEntryAction;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.CompositeIdFetcher;
import org.jabref.logic.importer.FetcherClientException;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.FetcherServerException;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateEntryFromIdAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateEntryFromIdAction.class);
    private final LibraryTab libraryTab;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final String identifier;
    private final TaskExecutor taskExecutor;
    private final PopOver entryFromIdPopOver;
    private final StateManager stateManager;
    private final FileUpdateMonitor fileUpdateMonitor;

    public GenerateEntryFromIdAction(LibraryTab libraryTab, DialogService dialogService, PreferencesService preferencesService, TaskExecutor taskExecutor, PopOver entryFromIdPopOver, String identifier, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor) {
        this.libraryTab = libraryTab;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.identifier = identifier;
        this.taskExecutor = taskExecutor;
        this.entryFromIdPopOver = entryFromIdPopOver;
        this.stateManager = stateManager;
        this.fileUpdateMonitor = fileUpdateMonitor;
    }

    public void execute() {
        BackgroundTask<Optional<BibEntry>> backgroundTask = this.searchAndImportEntryInBackground();
        backgroundTask.titleProperty().set((Object)Localization.lang("Import by ID", new Object[0]));
        backgroundTask.showToUser(true);
        backgroundTask.onRunning(() -> {
            this.entryFromIdPopOver.hide();
            this.dialogService.notify("%s".formatted(backgroundTask.messageProperty().get()));
        });
        backgroundTask.onFailure(exception -> {
            String fetcherExceptionMessage = exception.getMessage();
            Object msg = exception instanceof FetcherClientException ? Localization.lang("Bibliographic data not found. Cause is likely the client side. Please check connection and identifier for correctness.", new Object[0]) + "\n" + fetcherExceptionMessage : (exception instanceof FetcherServerException ? Localization.lang("Bibliographic data not found. Cause is likely the server side. Please try again later.", new Object[0]) + "\n" + fetcherExceptionMessage : Localization.lang("Error message %0", fetcherExceptionMessage));
            LOGGER.info(fetcherExceptionMessage, (Throwable)exception);
            if (this.dialogService.showConfirmationDialogAndWait(Localization.lang("Failed to import by ID", new Object[0]), (String)msg, Localization.lang("Add entry manually", new Object[0]))) {
                new NewEntryAction(() -> this.libraryTab, StandardEntryType.Article, this.dialogService, this.preferencesService, this.stateManager).execute();
            }
        });
        backgroundTask.onSuccess(result -> {
            if (result.isPresent()) {
                BibEntry entry = (BibEntry)result.get();
                ImportHandler handler = new ImportHandler(this.libraryTab.getBibDatabaseContext(), this.preferencesService, this.fileUpdateMonitor, this.libraryTab.getUndoManager(), this.stateManager, this.dialogService, this.taskExecutor);
                handler.importEntryWithDuplicateCheck(this.libraryTab.getBibDatabaseContext(), entry);
            } else {
                this.dialogService.notify("No entry found or import canceled");
            }
        });
        backgroundTask.executeWith(this.taskExecutor);
    }

    private BackgroundTask<Optional<BibEntry>> searchAndImportEntryInBackground() {
        return new BackgroundTask<Optional<BibEntry>>(){

            @Override
            protected Optional<BibEntry> call() throws FetcherException {
                if (this.isCanceled()) {
                    return Optional.empty();
                }
                this.updateMessage(Localization.lang("Searching...", new Object[0]));
                return new CompositeIdFetcher(GenerateEntryFromIdAction.this.preferencesService.getImportFormatPreferences()).performSearchById(GenerateEntryFromIdAction.this.identifier);
            }
        };
    }
}

