/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.util.List;
import java.util.Objects;
import org.jabref.gui.groups.GroupTreeNodeViewModel;
import org.jabref.gui.groups.MoveGroupChange;
import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.groups.GroupTreeNode;

class UndoableMoveGroup
extends AbstractUndoableJabRefEdit {
    private final GroupTreeNodeViewModel root;
    private final List<Integer> pathToNewParent;
    private final int newChildIndex;
    private final List<Integer> pathToOldParent;
    private final int oldChildIndex;

    public UndoableMoveGroup(GroupTreeNodeViewModel root, MoveGroupChange moveChange) {
        this.root = Objects.requireNonNull(root);
        Objects.requireNonNull(moveChange);
        this.pathToOldParent = moveChange.getOldParent().getIndexedPathFromRoot();
        this.pathToNewParent = moveChange.getNewParent().getIndexedPathFromRoot();
        this.oldChildIndex = moveChange.getOldChildIndex();
        this.newChildIndex = moveChange.getNewChildIndex();
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("move group", new Object[0]);
    }

    @Override
    public void undo() {
        super.undo();
        GroupTreeNode newParent = (GroupTreeNode)this.root.getNode().getDescendant(this.pathToNewParent).get();
        GroupTreeNode node = (GroupTreeNode)newParent.getChildAt(this.newChildIndex).get();
        node.moveTo((GroupTreeNode)this.root.getNode().getDescendant(this.pathToOldParent).get(), this.oldChildIndex);
    }

    @Override
    public void redo() {
        super.redo();
        GroupTreeNode oldParent = (GroupTreeNode)this.root.getNode().getDescendant(this.pathToOldParent).get();
        GroupTreeNode node = (GroupTreeNode)oldParent.getChildAt(this.oldChildIndex).get();
        node.moveTo((GroupTreeNode)this.root.getNode().getDescendant(this.pathToNewParent).get(), this.newChildIndex);
    }
}

