/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import com.airhacks.afterburner.injection.Injector;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.duplicationFinder.DuplicateResolverDialog;
import org.jabref.gui.externalfiles.DuplicateDecisionResult;
import org.jabref.gui.externalfiles.ExternalFilesEntryLinker;
import org.jabref.gui.externalfiles.ImportFilesResultItemViewModel;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.libraryproperties.constants.ConstantsItemModel;
import org.jabref.gui.undo.UndoableInsertEntries;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.database.DuplicateCheck;
import org.jabref.logic.externalfiles.ExternalFilesContentImporter;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ImportCleanup;
import org.jabref.logic.importer.ImportException;
import org.jabref.logic.importer.ImportFormatReader;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fetcher.ArXivFetcher;
import org.jabref.logic.importer.fetcher.DoiFetcher;
import org.jabref.logic.importer.fetcher.isbntobibtex.IsbnFetcher;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.UpdateField;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.KeyCollisionException;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.ArXivIdentifier;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.identifier.ISBN;
import org.jabref.model.groups.GroupEntryChanger;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.model.util.OptionalUtil;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportHandler.class);
    private final BibDatabaseContext bibDatabaseContext;
    private final PreferencesService preferences;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final ExternalFilesEntryLinker linker;
    private final ExternalFilesContentImporter contentImporter;
    private final UndoManager undoManager;
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;

    public ImportHandler(BibDatabaseContext database, PreferencesService preferences, FileUpdateMonitor fileupdateMonitor, UndoManager undoManager, StateManager stateManager, DialogService dialogService, TaskExecutor taskExecutor) {
        this.bibDatabaseContext = database;
        this.preferences = preferences;
        this.fileUpdateMonitor = fileupdateMonitor;
        this.stateManager = stateManager;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.linker = new ExternalFilesEntryLinker(preferences.getFilePreferences(), database, dialogService);
        this.contentImporter = new ExternalFilesContentImporter(preferences.getImportFormatPreferences());
        this.undoManager = undoManager;
    }

    public ExternalFilesEntryLinker getLinker() {
        return this.linker;
    }

    public BackgroundTask<List<ImportFilesResultItemViewModel>> importFilesInBackground(final List<Path> files) {
        return new BackgroundTask<List<ImportFilesResultItemViewModel>>(){
            private int counter;
            private final List<ImportFilesResultItemViewModel> results = new ArrayList<ImportFilesResultItemViewModel>();

            @Override
            protected List<ImportFilesResultItemViewModel> call() {
                this.counter = 1;
                CompoundEdit ce = new CompoundEdit();
                for (Path file : files) {
                    ArrayList<BibEntry> entriesToAdd = new ArrayList<BibEntry>();
                    if (this.isCanceled()) break;
                    UiTaskExecutor.runInJavaFXThread(() -> {
                        this.updateMessage(Localization.lang("Processing file %0", file.getFileName()));
                        this.updateProgress(this.counter, (double)files.size() - 1.0);
                    });
                    try {
                        if (FileUtil.isPDFFile(file)) {
                            ParserResult pdfImporterResult = ImportHandler.this.contentImporter.importPDFContent(file);
                            ObservableList<BibEntry> pdfEntriesInFile = pdfImporterResult.getDatabase().getEntries();
                            if (pdfImporterResult.hasWarnings()) {
                                this.addResultToList(file, false, Localization.lang("Error reading PDF content: %0", pdfImporterResult.getErrorMessage()));
                            }
                            if (!pdfEntriesInFile.isEmpty()) {
                                entriesToAdd.addAll((Collection<BibEntry>)pdfEntriesInFile);
                                this.addResultToList(file, true, Localization.lang("File was successfully imported as a new entry", new Object[0]));
                            } else {
                                entriesToAdd.add(ImportHandler.this.createEmptyEntryWithLink(file));
                                this.addResultToList(file, false, Localization.lang("No metadata was found. An empty entry was created with file link", new Object[0]));
                            }
                        } else if (FileUtil.isBibFile(file)) {
                            ParserResult bibtexParserResult = ImportHandler.this.contentImporter.importFromBibFile(file, ImportHandler.this.fileUpdateMonitor);
                            if (bibtexParserResult.hasWarnings()) {
                                this.addResultToList(file, false, bibtexParserResult.getErrorMessage());
                            }
                            entriesToAdd.addAll(bibtexParserResult.getDatabaseContext().getEntries());
                            this.addResultToList(file, true, Localization.lang("Bib entry was successfully imported", new Object[0]));
                        } else {
                            entriesToAdd.add(ImportHandler.this.createEmptyEntryWithLink(file));
                            this.addResultToList(file, false, Localization.lang("No BibTeX data was found. An empty entry was created with file link", new Object[0]));
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.error("Error importing", (Throwable)ex);
                        this.addResultToList(file, false, Localization.lang("Error from import: %0", ex.getLocalizedMessage()));
                        UiTaskExecutor.runInJavaFXThread(() -> this.updateMessage(Localization.lang("Error", new Object[0])));
                    }
                    UiTaskExecutor.runInJavaFXThread(() -> ImportHandler.this.importEntries(entriesToAdd));
                    ce.addEdit(new UndoableInsertEntries(ImportHandler.this.bibDatabaseContext.getDatabase(), entriesToAdd));
                    ce.end();
                    ImportHandler.this.undoManager.addEdit(ce);
                    ++this.counter;
                }
                return this.results;
            }

            private void addResultToList(Path newFile, boolean success, String logMessage) {
                ImportFilesResultItemViewModel result = new ImportFilesResultItemViewModel(newFile, success, logMessage);
                this.results.add(result);
            }
        };
    }

    private BibEntry createEmptyEntryWithLink(Path file) {
        BibEntry entry = new BibEntry();
        entry.setField(StandardField.TITLE, file.getFileName().toString());
        this.linker.addFilesToEntry(entry, Collections.singletonList(file));
        return entry;
    }

    public void importEntries(List<BibEntry> entries) {
        ImportCleanup cleanup = ImportCleanup.targeting(this.bibDatabaseContext.getMode(), this.preferences.getFieldPreferences());
        cleanup.doPostCleanup(entries);
        this.importCleanedEntries(entries);
    }

    public void importCleanedEntries(List<BibEntry> entries) {
        this.bibDatabaseContext.getDatabase().insertEntries(entries);
        this.generateKeys(entries);
        this.setAutomaticFields(entries);
        this.addToGroups(entries, (Collection<GroupTreeNode>)this.stateManager.getSelectedGroups(this.bibDatabaseContext));
    }

    public void importEntryWithDuplicateCheck(BibDatabaseContext bibDatabaseContext, BibEntry entry) {
        this.importEntryWithDuplicateCheck(bibDatabaseContext, entry, DuplicateResolverDialog.DuplicateResolverResult.BREAK);
    }

    private void importEntryWithDuplicateCheck(BibDatabaseContext bibDatabaseContext, BibEntry entry, DuplicateResolverDialog.DuplicateResolverResult decision) {
        BibEntry entryToInsert = this.cleanUpEntry(bibDatabaseContext, entry);
        Optional<BibEntry> existingDuplicateInLibrary = this.findDuplicate(bibDatabaseContext, entryToInsert);
        if (existingDuplicateInLibrary.isPresent()) {
            Optional<BibEntry> duplicateHandledEntry = this.handleDuplicates(bibDatabaseContext, entryToInsert, existingDuplicateInLibrary.get(), decision);
            if (duplicateHandledEntry.isEmpty()) {
                return;
            }
            entryToInsert = duplicateHandledEntry.get();
        }
        this.importCleanedEntries(List.of(entryToInsert));
        this.downloadLinkedFiles(entryToInsert);
    }

    @VisibleForTesting
    BibEntry cleanUpEntry(BibDatabaseContext bibDatabaseContext, BibEntry entry) {
        ImportCleanup cleanup = ImportCleanup.targeting(bibDatabaseContext.getMode(), this.preferences.getFieldPreferences());
        return cleanup.doPostCleanup(entry);
    }

    public Optional<BibEntry> findDuplicate(BibDatabaseContext bibDatabaseContext, BibEntry entryToCheck) {
        return new DuplicateCheck((BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class)).containsDuplicate(bibDatabaseContext.getDatabase(), entryToCheck, bibDatabaseContext.getMode());
    }

    public Optional<BibEntry> handleDuplicates(BibDatabaseContext bibDatabaseContext, BibEntry originalEntry, BibEntry duplicateEntry, DuplicateResolverDialog.DuplicateResolverResult decision) {
        DuplicateDecisionResult decisionResult = this.getDuplicateDecision(originalEntry, duplicateEntry, bibDatabaseContext, decision);
        switch (decisionResult.decision()) {
            case KEEP_RIGHT: {
                bibDatabaseContext.getDatabase().removeEntry(duplicateEntry);
                break;
            }
            case KEEP_BOTH: {
                break;
            }
            case KEEP_MERGE: {
                bibDatabaseContext.getDatabase().removeEntry(duplicateEntry);
                return Optional.of(decisionResult.mergedEntry());
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(originalEntry);
    }

    public DuplicateDecisionResult getDuplicateDecision(BibEntry originalEntry, BibEntry duplicateEntry, BibDatabaseContext bibDatabaseContext, DuplicateResolverDialog.DuplicateResolverResult decision) {
        DuplicateResolverDialog dialog = new DuplicateResolverDialog(duplicateEntry, originalEntry, DuplicateResolverDialog.DuplicateResolverType.IMPORT_CHECK, bibDatabaseContext, this.stateManager, this.dialogService, this.preferences);
        if (decision == DuplicateResolverDialog.DuplicateResolverResult.BREAK) {
            decision = this.dialogService.showCustomDialogAndWait(dialog).orElse(DuplicateResolverDialog.DuplicateResolverResult.BREAK);
        }
        if (this.preferences.getMergeDialogPreferences().shouldMergeApplyToAllEntries().booleanValue()) {
            this.preferences.getMergeDialogPreferences().setAllEntriesDuplicateResolverDecision(decision);
        }
        return new DuplicateDecisionResult(decision, dialog.getMergedEntry());
    }

    public void setAutomaticFields(List<BibEntry> entries) {
        UpdateField.setAutomaticFields(entries, this.preferences.getOwnerPreferences(), this.preferences.getTimestampPreferences());
    }

    public void downloadLinkedFiles(BibEntry entry) {
        if (this.preferences.getFilePreferences().shouldDownloadLinkedFiles()) {
            entry.getFiles().stream().filter(LinkedFile::isOnlineLink).forEach(linkedFile -> new LinkedFileViewModel((LinkedFile)linkedFile, entry, this.bibDatabaseContext, this.taskExecutor, this.dialogService, this.preferences).download(false));
        }
    }

    private void addToGroups(List<BibEntry> entries, Collection<GroupTreeNode> groups) {
        for (GroupTreeNode node : groups) {
            Object object = node.getGroup();
            if (!(object instanceof GroupEntryChanger)) continue;
            GroupEntryChanger entryChanger = (GroupEntryChanger)object;
            object = entryChanger.add(entries);
        }
    }

    private void generateKeys(List<BibEntry> entries) {
        if (!this.preferences.getImporterPreferences().isGenerateNewKeyOnImport()) {
            return;
        }
        CitationKeyGenerator keyGenerator = new CitationKeyGenerator(this.bibDatabaseContext.getMetaData().getCiteKeyPatterns(this.preferences.getCitationKeyPatternPreferences().getKeyPatterns()), this.bibDatabaseContext.getDatabase(), this.preferences.getCitationKeyPatternPreferences());
        entries.forEach(keyGenerator::generateAndSetKey);
    }

    public List<BibEntry> handleBibTeXData(String entries) {
        BibtexParser parser = new BibtexParser(this.preferences.getImportFormatPreferences(), this.fileUpdateMonitor);
        try {
            List<BibEntry> result = parser.parseEntries(new ByteArrayInputStream(entries.getBytes(StandardCharsets.UTF_8)));
            Collection<BibtexString> stringConstants = parser.getStringValues();
            this.importStringConstantsWithDuplicateCheck(stringConstants);
            return result;
        }
        catch (ParseException ex) {
            LOGGER.error("Could not paste", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public void importStringConstantsWithDuplicateCheck(Collection<BibtexString> stringConstants) {
        ArrayList<String> failures = new ArrayList<String>();
        for (BibtexString stringConstantToAdd : stringConstants) {
            try {
                ConstantsItemModel checker = new ConstantsItemModel(stringConstantToAdd.getName(), stringConstantToAdd.getContent());
                if (checker.combinedValidationValidProperty().get()) {
                    this.bibDatabaseContext.getDatabase().addString(stringConstantToAdd);
                    continue;
                }
                failures.add(Localization.lang("String constant \"%0\" was not imported because it is not a valid string constant", stringConstantToAdd.getName()));
            }
            catch (KeyCollisionException ex) {
                failures.add(Localization.lang("String constant %0 was not imported because it already exists in this library", stringConstantToAdd.getName()));
            }
        }
        if (!failures.isEmpty()) {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Importing String constants", new Object[0]), Localization.lang("Could not import the following string constants:\n %0", String.join((CharSequence)"\n", failures)));
        }
    }

    public List<BibEntry> handleStringData(String data) throws FetcherException {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<DOI> doi = DOI.findInText(data);
        if (doi.isPresent()) {
            return this.fetchByDOI(doi.get());
        }
        Optional<ArXivIdentifier> arXiv = ArXivIdentifier.parse(data);
        if (arXiv.isPresent()) {
            return this.fetchByArXiv(arXiv.get());
        }
        Optional<ISBN> isbn = ISBN.parse(data);
        if (isbn.isPresent()) {
            return this.fetchByISBN(isbn.get());
        }
        return this.tryImportFormats(data);
    }

    private List<BibEntry> tryImportFormats(String data) {
        try {
            ImportFormatReader importFormatReader = new ImportFormatReader(this.preferences.getImporterPreferences(), this.preferences.getImportFormatPreferences(), this.preferences.getCitationKeyPatternPreferences(), this.fileUpdateMonitor);
            ImportFormatReader.UnknownFormatImport unknownFormatImport = importFormatReader.importUnknownFormat(data);
            return unknownFormatImport.parserResult().getDatabase().getEntries();
        }
        catch (ImportException ex) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Import error", new Object[0]), ex);
            return Collections.emptyList();
        }
    }

    private List<BibEntry> fetchByDOI(DOI doi) throws FetcherException {
        LOGGER.info("Found DOI identifier in clipboard");
        Optional<BibEntry> entry = new DoiFetcher(this.preferences.getImportFormatPreferences()).performSearchById(doi.getDOI());
        return OptionalUtil.toList(entry);
    }

    private List<BibEntry> fetchByArXiv(ArXivIdentifier arXivIdentifier) throws FetcherException {
        LOGGER.info("Found arxiv identifier in clipboard");
        Optional<BibEntry> entry = new ArXivFetcher(this.preferences.getImportFormatPreferences()).performSearchById(arXivIdentifier.getNormalizedWithoutVersion());
        return OptionalUtil.toList(entry);
    }

    private List<BibEntry> fetchByISBN(ISBN isbn) throws FetcherException {
        LOGGER.info("Found ISBN identifier in clipboard");
        Optional<BibEntry> entry = new IsbnFetcher(this.preferences.getImportFormatPreferences()).performSearchById(isbn.getNormalized());
        return OptionalUtil.toList(entry);
    }

    public void importEntriesWithDuplicateCheck(BibDatabaseContext database, List<BibEntry> entriesToAdd) {
        boolean firstEntry = true;
        for (BibEntry entry : entriesToAdd) {
            if (firstEntry) {
                LOGGER.debug("First entry to import, we use BREAK (\"Ask every time\") as decision");
                this.importEntryWithDuplicateCheck(database, entry, DuplicateResolverDialog.DuplicateResolverResult.BREAK);
                firstEntry = false;
                continue;
            }
            if (this.preferences.getMergeDialogPreferences().shouldMergeApplyToAllEntries().booleanValue()) {
                DuplicateResolverDialog.DuplicateResolverResult decision = this.preferences.getMergeDialogPreferences().getAllEntriesDuplicateResolverDecision();
                LOGGER.debug("Not first entry, pref flag is true, we use {}", (Object)decision);
                this.importEntryWithDuplicateCheck(database, entry, decision);
                continue;
            }
            LOGGER.debug("not first entry, not pref flag, break will  be used");
            this.importEntryWithDuplicateCheck(database, entry);
        }
    }
}

