/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.externalfiles.AutoSetFileLinksUtil;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class AutoLinkFilesAction
extends SimpleCommand {
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final StateManager stateManager;
    private final UndoManager undoManager;
    private final TaskExecutor taskExecutor;

    public AutoLinkFilesAction(DialogService dialogService, PreferencesService preferences, StateManager stateManager, UndoManager undoManager, TaskExecutor taskExecutor) {
        this.dialogService = dialogService;
        this.preferences = preferences;
        this.stateManager = stateManager;
        this.undoManager = undoManager;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(this.stateManager).and((ObservableBooleanValue)ActionHelper.needsEntriesSelected(stateManager)));
        this.statusMessage.bind(BindingsHelper.ifThenElse((ObservableValue<Boolean>)this.executable, "", Localization.lang("This operation requires one or more entries to be selected.", new Object[0])));
    }

    public void execute() {
        BibDatabaseContext database = this.stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("Database null"));
        final ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        final AutoSetFileLinksUtil util = new AutoSetFileLinksUtil(database, this.preferences.getFilePreferences(), this.preferences.getAutoLinkPreferences());
        final NamedCompound nc = new NamedCompound(Localization.lang("Automatically set file links", new Object[0]));
        Task<AutoSetFileLinksUtil.LinkFilesResult> linkFilesTask = new Task<AutoSetFileLinksUtil.LinkFilesResult>(){

            protected AutoSetFileLinksUtil.LinkFilesResult call() {
                return util.linkAssociatedFiles(entries, nc);
            }

            protected void succeeded() {
                AutoSetFileLinksUtil.LinkFilesResult result = (AutoSetFileLinksUtil.LinkFilesResult)this.getValue();
                if (!result.getFileExceptions().isEmpty()) {
                    AutoLinkFilesAction.this.dialogService.showWarningDialogAndWait(Localization.lang("Automatically set file links", new Object[0]), Localization.lang("Problem finding files. See error log for details.", new Object[0]));
                    return;
                }
                if (result.getChangedEntries().isEmpty()) {
                    AutoLinkFilesAction.this.dialogService.showWarningDialogAndWait("Automatically set file links", Localization.lang("Finished automatically setting external links.", new Object[0]) + "\n" + Localization.lang("No files found.", new Object[0]));
                    return;
                }
                if (nc.hasEdits()) {
                    nc.end();
                    AutoLinkFilesAction.this.undoManager.addEdit(nc);
                }
                AutoLinkFilesAction.this.dialogService.notify(Localization.lang("Finished automatically setting external links.", new Object[0]) + " " + Localization.lang("Changed %0 entries.", String.valueOf(result.getChangedEntries().size())));
            }
        };
        this.dialogService.showProgressDialog(Localization.lang("Automatically setting file links", new Object[0]), Localization.lang("Searching for files", new Object[0]), linkFilesTask);
        this.taskExecutor.execute(linkFilesTask);
    }
}

