/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import com.airhacks.afterburner.injection.Injector;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.ClipboardContent;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.ExporterFactory;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportToClipboardAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportToClipboardAction.class);
    private static final Set<FileType> SUPPORTED_FILETYPES = Set.of(StandardFileType.TXT, StandardFileType.RTF, StandardFileType.RDF, StandardFileType.XML, StandardFileType.HTML, StandardFileType.CSV, StandardFileType.RIS);
    private final DialogService dialogService;
    private final List<BibEntry> entries = new ArrayList<BibEntry>();
    private final ClipBoardManager clipBoardManager;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferences;
    private final StateManager stateManager;

    public ExportToClipboardAction(DialogService dialogService, StateManager stateManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.clipBoardManager = clipBoardManager;
        this.taskExecutor = taskExecutor;
        this.preferences = preferencesService;
        this.stateManager = stateManager;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        if (this.stateManager.getSelectedEntries().isEmpty()) {
            this.dialogService.notify(Localization.lang("This operation requires one or more entries to be selected.", new Object[0]));
            return;
        }
        ExporterFactory exporterFactory = ExporterFactory.create(this.preferences, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class));
        List exporters = exporterFactory.getExporters().stream().sorted(Comparator.comparing(Exporter::getName)).filter(exporter -> SUPPORTED_FILETYPES.contains(exporter.getFileType())).collect(Collectors.toList());
        Exporter defaultChoice = exporters.stream().filter(exporter -> exporter.getName().equals(this.preferences.getExportPreferences().getLastExportExtension())).findAny().orElse(null);
        Optional<Exporter> selectedExporter = this.dialogService.showChoiceDialogAndWait(Localization.lang("Export", new Object[0]), Localization.lang("Select export format", new Object[0]), Localization.lang("Export", new Object[0]), defaultChoice, exporters);
        selectedExporter.ifPresent(exporter -> BackgroundTask.wrap(() -> this.exportToClipboard((Exporter)exporter)).onSuccess(this::setContentToClipboard).onFailure(ex -> {
            LOGGER.error("Error exporting to clipboard", (Throwable)ex);
            this.dialogService.showErrorDialogAndWait("Error exporting to clipboard", (Throwable)ex);
        }).executeWith(this.taskExecutor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportResult exportToClipboard(Exporter exporter) throws Exception {
        List<Path> fileDirForDatabase = this.stateManager.getActiveDatabase().map(db -> db.getFileDirectories(this.preferences.getFilePreferences())).orElse(List.of(this.preferences.getFilePreferences().getWorkingDirectory()));
        this.preferences.getExportPreferences().setLastExportExtension(exporter.getName());
        Path tmp = null;
        try {
            tmp = Files.createTempFile("jabrefCb", ".tmp", new FileAttribute[0]);
            this.entries.addAll((Collection<BibEntry>)this.stateManager.getSelectedEntries());
            exporter.export(this.stateManager.getActiveDatabase().get(), tmp, this.entries, fileDirForDatabase, (JournalAbbreviationRepository)Injector.instantiateModelOrService(JournalAbbreviationRepository.class));
            ExportResult exportResult = new ExportResult(Files.readString(tmp), exporter.getFileType());
            return exportResult;
        }
        finally {
            if (tmp != null && Files.exists(tmp, new LinkOption[0])) {
                try {
                    Files.delete(tmp);
                }
                catch (IOException e) {
                    LOGGER.info("Cannot delete temporary clipboard file", (Throwable)e);
                }
            }
        }
    }

    private void setContentToClipboard(ExportResult result) {
        ClipboardContent clipboardContent = new ClipboardContent();
        List<String> extensions = result.fileType.getExtensions();
        if (extensions.contains("html")) {
            clipboardContent.putHtml(result.content);
        } else if (extensions.contains("rtf")) {
            clipboardContent.putRtf(result.content);
        } else if (extensions.contains("rdf")) {
            clipboardContent.putRtf(result.content);
        }
        clipboardContent.putString(result.content);
        this.clipBoardManager.setContent(clipboardContent);
        this.dialogService.notify(Localization.lang("Entries exported to clipboard", new Object[0]) + ": " + this.entries.size());
    }

    private record ExportResult(String content, FileType fileType) {
    }
}

