/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret.handlers;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.interfaces.Collection;
import org.freedesktop.secret.interfaces.Prompt;
import org.freedesktop.secret.interfaces.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHandler
implements DBusSigHandler {
    private static final int bufferSize = 1024;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private DBusConnection connection = null;
    private List<Class<? extends DBusSignal>> registered = new ArrayList<Class<? extends DBusSignal>>();
    private DBusSignal[] handled = new DBusSignal[1024];
    private int count = 0;

    public static SignalHandler getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public void connect(DBusConnection connection, List<Class<? extends DBusSignal>> signals) {
        if (this.connection == null) {
            this.connection = connection;
        }
        if (signals != null) {
            try {
                for (Class<? extends DBusSignal> sc : signals) {
                    if (this.registered.contains(sc)) continue;
                    connection.addSigHandler(sc, (DBusSigHandler)this);
                    this.registered.add(sc);
                }
            }
            catch (DBusException e) {
                this.log.error("Could not connect to the D-Bus.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(DBusSignal s) {
        DBusSignal[] dBusSignalArray = this.handled;
        synchronized (this.handled) {
            DBusSignal cc;
            DBusSignal ic;
            Collections.rotate(Arrays.asList(this.handled), 1);
            this.handled[0] = s;
            ++this.count;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (s instanceof Collection.ItemCreated) {
                ic = (Collection.ItemCreated)s;
                this.log.info("Received signal Collection.ItemCreated: " + ic.item);
            } else if (s instanceof Collection.ItemChanged) {
                ic = (Collection.ItemChanged)s;
                this.log.debug("Received signal Collection.ItemChanged: " + ic.item);
            } else if (s instanceof Collection.ItemDeleted) {
                ic = (Collection.ItemDeleted)s;
                this.log.info("Received signal Collection.ItemDeleted: " + ic.item);
            } else if (s instanceof Prompt.Completed) {
                Prompt.Completed c = (Prompt.Completed)s;
                this.log.info("Received signal Prompt.Completed(" + s.getPath() + "): {dismissed: " + c.dismissed + ", result: " + c.result + "}");
            } else if (s instanceof Service.CollectionCreated) {
                cc = (Service.CollectionCreated)s;
                this.log.info("Received signal Service.CollectionCreated: " + cc.collection);
            } else if (s instanceof Service.CollectionChanged) {
                cc = (Service.CollectionChanged)s;
                this.log.info("Received signal Service.CollectionChanged: " + cc.collection);
            } else if (s instanceof Service.CollectionDeleted) {
                cc = (Service.CollectionDeleted)s;
                this.log.info("Received signal Service.CollectionDeleted: " + cc.collection);
            } else {
                try {
                    this.log.warn("Received unexpected signal: " + s.getClass().toString() + " {" + s.toString() + "}");
                }
                catch (NullPointerException e) {
                    this.log.warn("Received unknown signal.");
                }
            }
            return;
        }
    }

    public DBusSignal[] getHandled() {
        return this.handled;
    }

    public <S extends DBusSignal> List<S> getHandledSignals(Class<S> s) {
        return Arrays.stream(this.handled).filter(signal -> signal != null).filter(signal -> signal.getClass().equals(s)).map(signal -> signal).collect(Collectors.toList());
    }

    public <S extends DBusSignal> List<S> getHandledSignals(Class<S> s, String path) {
        return Arrays.stream(this.handled).filter(signal -> signal != null).filter(signal -> signal.getClass().equals(s)).filter(signal -> signal.getPath().equals(path)).map(signal -> signal).collect(Collectors.toList());
    }

    public int getCount() {
        return this.count;
    }

    public DBusSignal getLastHandledSignal() {
        return this.handled[0];
    }

    public <S extends DBusSignal> S getLastHandledSignal(Class<S> s) {
        List<S> signals = this.getHandledSignals(s);
        if (signals != null && !signals.isEmpty()) {
            return (S)((DBusSignal)signals.get(0));
        }
        return null;
    }

    public <S extends DBusSignal> S getLastHandledSignal(Class<S> s, String path) {
        List<S> signals = this.getHandledSignals(s, path);
        if (signals != null && !signals.isEmpty()) {
            return (S)((DBusSignal)signals.get(0));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends DBusSignal> S await(Class<S> signal, String path, Callable action, Duration timeout) {
        int init = this.count;
        Object prompt = null;
        try {
            prompt = action.call();
        }
        catch (Exception e) {
            this.log.error("Cloud not acquire a prompt.", (Throwable)e);
        }
        try {
            this.log.info(String.format("Await signal %s.%s(%s) within %d seconds.", signal.getEnclosingClass().getSimpleName(), signal.getSimpleName(), path, timeout.getSeconds()));
        }
        catch (NullPointerException e) {
            this.log.error("Await signal for unknown class.");
        }
        ExecutorService executor = Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable, "secret-service:signal-handler");
            thread.setDaemon(true);
            return thread;
        });
        Future<Object> handler = executor.submit(() -> {
            int current = init;
            int last = init;
            List signals = null;
            while (!Thread.currentThread().isInterrupted()) {
                Thread.currentThread();
                Thread.sleep(Static.DBus.DEFAULT_DELAY_MILLIS);
                current = this.getCount();
                if (current == last) continue;
                signals = this.getHandledSignals(signal, path);
                if (signals != null && !signals.isEmpty()) {
                    return signals.get(0);
                }
                last = current;
            }
            return null;
        });
        try {
            long start = System.nanoTime();
            long nanos = timeout.toNanos();
            while (!Thread.currentThread().isInterrupted()) {
                long now = System.nanoTime();
                if (handler.isDone()) {
                    DBusSignal dBusSignal = (DBusSignal)handler.get();
                    return (S)dBusSignal;
                }
                if (now - start > nanos) {
                    throw new TimeoutException();
                }
                Thread.currentThread();
                Thread.sleep(Static.DBus.DEFAULT_DELAY_MILLIS);
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
            if (prompt != null && prompt instanceof Prompt) {
                ((Prompt)prompt).dismiss();
                this.log.warn("Cancelled the prompt (" + path + ") manually after exceeding the timeout of " + timeout.getSeconds() + " seconds.");
            } else {
                this.log.warn("Cancelled the action, but could not dismiss the prompt.", (Throwable)e);
            }
        }
        finally {
            handler.cancel(true);
            executor.shutdownNow();
        }
        return null;
    }

    private static class SingletonHelper {
        private static final SignalHandler INSTANCE = new SignalHandler();

        private SingletonHelper() {
        }
    }
}

