import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.averages import CT06_MWLoc

fig, ax = plt.subplots()

# define the extinction model
ext_model = CT06_MWLoc()

# generate the curves and plot them
x = np.arange(1.0/ext_model.x_range[1], 1.0/ext_model.x_range[0], 0.1) * u.micron

ax.plot(x,ext_model(x),label='CT06_MWLoc')
ax.plot(1.0/ext_model.obsdata_x, ext_model.obsdata_axav, 'ko',
        label='obsdata')

ax.set_xlabel(r'$\lambda$ [$\mu m$]')
ax.set_ylabel(r'$A(x)/A(V)$')

ax.legend(loc='best')
plt.show()