import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.averages import G03_LMCAvg

fig, ax = plt.subplots()

# define the extinction model
ext_model = G03_LMCAvg()

# generate the curves and plot them
x = np.arange(ext_model.x_range[0], ext_model.x_range[1],0.1)/u.micron

ax.plot(x,ext_model(x),label='G03 LMCAvg')
ax.plot(ext_model.obsdata_x, ext_model.obsdata_axav, 'ko',
        label='obsdata')

ax.set_xlabel(r'$x$ [$\mu m^{-1}$]')
ax.set_ylabel(r'$A(x)/A(V)$')

# for 2nd x-axis with lambda values
axis_xs = np.array([0.1, 0.12, 0.15, 0.2, 0.3, 0.5, 1.0])
new_ticks = 1 / axis_xs
new_ticks_labels = ["%.2f" % z for z in axis_xs]
tax = ax.twiny()
tax.set_xlim(ax.get_xlim())
tax.set_xticks(new_ticks)
tax.set_xticklabels(new_ticks_labels)
tax.set_xlabel(r"$\lambda$ [$\mu$m]")

ax.legend(loc='best')
plt.show()