/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.plot.PanPlotUtils;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCombinePlotTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame frame_;
    private final NcVariable ncvar_;
    private NcArray ncarray_;
    private String errMsg_;

    public PanCombinePlotTask(PanPlotFrame frame, NcVariable ncvar) {
        super("Adding variable to plot");
        Objects.requireNonNull(frame, "Frame cannot be null.");
        Objects.requireNonNull(ncvar, "Variable cannot be null.");
        this.frame_ = frame;
        this.ncvar_ = ncvar;
    }

    @Override
    protected Object beginTask() {
        try {
            this.ncarray_ = PanPlotUtils.createCompatibleArray(this.ncvar_, this.frame_.getMeta());
            if (this.ncarray_ == null) {
                LOGGER.error("Null array returned.");
                this.errMsg_ = "Null array returned.";
                return null;
            }
        }
        catch (Exception exc) {
            LOGGER.error("There was an error preparing the data");
            LOGGER.error("{}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.getMessage();
            this.ncarray_ = null;
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.ncarray_ == null) {
            if (this.errMsg_ != null) {
                SlowMessage.show((Component)this.frame_, "Data Error", new StringBuilder("There was an error preparing the data: ").append(this.errMsg_));
            }
            return;
        }
        this.frame_.addArray(this.ncarray_);
        this.frame_.toFront();
    }
}

