/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class PanVersionPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox enabledCB_;
    private JLabel lastText_;

    public PanVersionPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.enabledCB_ = PanCheckBox.create("Allow Panoply to automatically query the GISS website for update notices");
        PanCheckBox junkCB = PanCheckBox.create("");
        int cbwidth = junkCB.getMinimumSize().width;
        JLabel lastText1 = new JLabel("Version info was last checked on ");
        this.lastText_ = new JLabel(prefs_.getString("app:version.last"));
        JLabel lastText3 = new JLabel(".");
        QuickBox noteBox = QuickBox.createLeftBox(Box.createHorizontalStrut(cbwidth), lastText1, this.lastText_, lastText3);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Software Update"));
        this.add((Component)QuickBox.createLeftBox(this.enabledCB_), (Object)Box.createHorizontalStrut(2));
        this.add(Box.createVerticalStrut(4));
        GuiUtils.setSizeSmall(noteBox);
        this.add(noteBox);
    }

    private void attachListeners() {
        this.enabledCB_.addItemListener(e -> prefs_.setBoolean("app:version.enabled", this.enabledCB_.isSelected()));
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        this.enabledCB_.setSelected(prefs_.getBoolean("app:version.enabled"));
        this.lastText_.setText(prefs_.getString("app:version.last"));
    }
}

