/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDataTime1D
extends PanData1D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String pattern_;

    public PanDataTime1D(PanPlotMeta pmeta, NcArray nca) {
        super(pmeta, nca);
        if (!(nca instanceof NcArray1D)) {
            throw new IllegalArgumentException("Array is not NcArray1D");
        }
        NcArray1D nca1d = (NcArray1D)nca;
        if (nca1d.isAxisUnixTime()) {
            this.pattern_ = nca1d.getAxisFormatPattern();
        } else {
            LOGGER.debug("NcArray1D does not use time pattern string");
        }
    }

    @Override
    public String getAxisLabel() {
        return "Time";
    }

    public String getAxisPattern() {
        return this.pattern_;
    }

    public void setAxisPattern(String pattern) {
        this.pattern_ = pattern;
        NcArray1D nca1d = (NcArray1D)this.ncArrays_[0];
        if (nca1d.isAxisUnixTime()) {
            nca1d.setAxisFormatPattern(pattern);
        } else {
            LOGGER.debug("NcArray1D does not accept time pattern string");
        }
    }
}

