/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface BonneCommon {
    public static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static double latitudeOfMaxX(double scaling, double phi1, double lambdaRad) {
        if (phi1 == 0.0) {
            return 0.0;
        }
        double phi1Rad = Math.toRadians(phi1);
        double cotPhi1 = 1.0 / Math.tan(phi1Rad);
        double cotPhi1PlusPhi1 = cotPhi1 + phi1Rad;
        double phiRad = -Math.toRadians(0.5 * phi1);
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double alphaRad = cotPhi1PlusPhi1 - phiRad;
            double oneOverAlphaRad = 1.0 / alphaRad;
            double betaRad = scaling * lambdaRad * cosPhi / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = (-scaling * lambdaRad * sinPhi + betaRad) / alphaRad;
            double d2betaRad = (-scaling * lambdaRad * cosPhi + 2.0 * dbetaRad) * oneOverAlphaRad;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double func = -sinBeta + alphaRad * dsinBeta;
            double dfunc = -2.0 * dsinBeta + alphaRad * (dcosBeta * dbetaRad + cosBeta * d2betaRad);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }

    public static double latitudeOfLobeMaxY(double scaling, double phi1, double lambdaRad) {
        double phi1Rad = Math.toRadians(phi1);
        double cotPhi1 = 1.0 / Math.tan(phi1Rad);
        double cotPhi1PlusPhi1 = cotPhi1 + phi1Rad;
        double phiRad = 0.7853981633974483;
        if (phi1 < 0.0) {
            phiRad = -phiRad;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double alphaRad = cotPhi1PlusPhi1 - phiRad;
            double oneOverAlphaRad = 1.0 / alphaRad;
            double betaRad = scaling * lambdaRad * cosPhi * oneOverAlphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = (-scaling * lambdaRad * sinPhi + betaRad) * oneOverAlphaRad;
            double d2betaRad = (-scaling * lambdaRad * cosPhi + 2.0 * dbetaRad) * oneOverAlphaRad;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double func = cosBeta - alphaRad * dcosBeta;
            double dfunc = 2.0 * dcosBeta + alphaRad * (dsinBeta * dbetaRad + sinBeta * d2betaRad);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-10) break;
        }
        return Math.toDegrees(phiRad);
    }
}

