/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.AdobeColorTable;
import gov.nasa.giss.graphics.clut.ClarisWorksColorTable;
import gov.nasa.giss.graphics.clut.CptColorTable;
import gov.nasa.giss.graphics.clut.GimpGradient;
import gov.nasa.giss.graphics.clut.GimpPalette;
import gov.nasa.giss.graphics.clut.GissColorTable;
import gov.nasa.giss.graphics.clut.NclRgbColorTable;
import gov.nasa.giss.graphics.clut.Pal1ColorTable;
import gov.nasa.giss.graphics.clut.Pal2ColorTable;
import gov.nasa.giss.graphics.clut.PalColorTable;
import gov.nasa.giss.graphics.clut.PyRgbColorTable;
import gov.nasa.giss.graphics.clut.SvgGradient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorTableFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static HashMap<String, Class<? extends AbstractColorTable>> cthash_ = new HashMap(25);

    private ColorTableFactory() {
    }

    public static boolean registerColorTableExt(String fext, Class<? extends AbstractColorTable> ctclass) {
        cthash_.put(fext.toLowerCase(), ctclass);
        return true;
    }

    public static boolean isColorTableName(File f) {
        return ColorTableFactory.isColorTableName(f.getName());
    }

    public static boolean isColorTableName(String fname) {
        Class<? extends AbstractColorTable> o = cthash_.get(fname.toLowerCase());
        return o != null;
    }

    public static AbstractColorTable create(String fext) {
        Class<? extends AbstractColorTable> ctClass = cthash_.get(fext.toLowerCase());
        if (ctClass == null) {
            throw new IllegalArgumentException("Unrecognized extension");
        }
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Constructor<? extends AbstractColorTable> c = ctClass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (Exception exc) {
            if (LOGGER.isDebugEnabled()) {
                exc.printStackTrace();
            }
            throw new IllegalArgumentException("Color table construction error: " + exc.toString());
        }
    }

    public static AbstractColorTable open(File file) throws FileNotFoundException, IOException, ParseException {
        Objects.requireNonNull("File cannot be null.");
        LOGGER.trace("f {}", (Object)file);
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("Not a file.");
        }
        String fname = file.getName();
        if (fname == null) {
            throw new FileNotFoundException("File not found.");
        }
        int dot = fname.lastIndexOf(46);
        if (dot < 1 || dot >= fname.length() - 2) {
            throw new FileNotFoundException("Bad file name.");
        }
        String fext = fname.substring(dot + 1);
        Class<? extends AbstractColorTable> ctClass = cthash_.get(fext.toLowerCase());
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension.");
        }
        try {
            Class[] types = new Class[]{File.class};
            Object[] args = new Object[]{file};
            Constructor<? extends AbstractColorTable> c = ctClass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (Exception exc) {
            LOGGER.error("Unable to open {} due to {}", (Object)fname, (Object)exc.toString());
            if (LOGGER.isDebugEnabled()) {
                exc.printStackTrace();
            }
            throw new ParseException("Could not extract color table information.", -1);
        }
    }

    public static AbstractColorTable open(URL url) throws FileNotFoundException, IOException, ParseException {
        Objects.requireNonNull(url, "URL cannot ne bull.");
        String fname = url.getFile();
        if (fname == null) {
            throw new FileNotFoundException("Bad URL");
        }
        int dot = fname.lastIndexOf(46);
        if (dot < 1 || dot >= fname.length() - 2) {
            throw new FileNotFoundException("Bad URL");
        }
        String fext = fname.substring(dot + 1);
        Class<? extends AbstractColorTable> ctClass = cthash_.get(fext.toLowerCase());
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{URL.class};
            Object[] args = new Object[]{url};
            Constructor<? extends AbstractColorTable> c = ctClass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (Exception exc) {
            LOGGER.error("Unable to open {} due to {}", (Object)fname, (Object)exc.toString());
            if (LOGGER.isDebugEnabled()) {
                exc.printStackTrace();
            }
            throw new ParseException("Could not extract color table information.", -1);
        }
    }

    public static AbstractColorTable open(byte[] bytes, String fext) throws IOException, ParseException {
        Class<? extends AbstractColorTable> ctClass = cthash_.get(fext.toLowerCase());
        if (ctClass == null) {
            throw new IllegalArgumentException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{byte[].class};
            Object[] args = new Object[]{bytes};
            Constructor<? extends AbstractColorTable> c = ctClass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (Exception exc) {
            LOGGER.error("{}", (Object)exc.toString());
            if (LOGGER.isDebugEnabled()) {
                exc.printStackTrace();
            }
            throw new ParseException("Could not extract color table information.", -1);
        }
    }

    public static String[] getValidExtensions() {
        Set<String> kset = cthash_.keySet();
        return kset.toArray(new String[cthash_.size()]);
    }

    static {
        ColorTableFactory.registerColorTableExt("pal", PalColorTable.class);
        ColorTableFactory.registerColorTableExt("pa1", Pal1ColorTable.class);
        ColorTableFactory.registerColorTableExt("pal1", Pal1ColorTable.class);
        ColorTableFactory.registerColorTableExt("pa2", Pal2ColorTable.class);
        ColorTableFactory.registerColorTableExt("pal2", Pal2ColorTable.class);
        ColorTableFactory.registerColorTableExt("cpt", CptColorTable.class);
        ColorTableFactory.registerColorTableExt("rgb", NclRgbColorTable.class);
        ColorTableFactory.registerColorTableExt("pyrgb", PyRgbColorTable.class);
        ColorTableFactory.registerColorTableExt("act", AdobeColorTable.class);
        ColorTableFactory.registerColorTableExt("gct", GissColorTable.class);
        ColorTableFactory.registerColorTableExt("cwc", ClarisWorksColorTable.class);
        ColorTableFactory.registerColorTableExt("gpl", GimpPalette.class);
        ColorTableFactory.registerColorTableExt("ggr", GimpGradient.class);
        ColorTableFactory.registerColorTableExt("svg", SvgGradient.class);
    }
}

