/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.proj4.CylindricalEqualAreaProjection;

public class NcArrayLonLatCylindricalEqualArea
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private Projection njProj_;
    private double sfactor_ = 1.0;
    private double rS_;
    private double oneOverRS_;
    private double scaleK0_ = 1.0;
    private double oneOverK0_ = 1.0;
    private double oneMinusE2_ = 1.0;
    private double oneOver2E_ = 0.5;
    private double qP_ = 1.0;
    private double authTerm1_;
    private double authTerm2_;
    private double authTerm3_;

    public NcArrayLonLatCylindricalEqualArea(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.CYL_EQUAL_AREA);
        this.initMe();
    }

    private void initMe() {
        LOGGER.trace("");
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.CYL_EQUAL_AREA)) {
            throw new NcException("Variable is not projected type cylindrical equal area.");
        }
        this.initGissProj();
        this.initGissProj();
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof CylindricalEqualAreaProjection)) {
            LOGGER.warn("Expected CylindricalEqualAreaProjection class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when CylindricalEqualAreaProjection was expected");
        }
        this.njProj_ = pj;
    }

    private void initGissProj() {
        LOGGER.trace("");
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("cylindrical_equal_area") && !this.mappingName_.equalsIgnoreCase("lambert_cylindrical_equal_area")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not cylindrical_equal_area or lambert_cylindrical_equal_area");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        LOGGER.trace("ellipsoid {}", (Object)this.ellipsoid_);
        Attribute sfactorA = this.mappingVarDS_.findAttribute("scale_factor_at_projection_origin");
        if (sfactorA == null) {
            this.setScalingFactor(1.0);
        } else {
            this.setScalingFactor(sfactorA.getNumericValue().doubleValue());
        }
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcException("Coordinate transform variable is missing standard parallel");
        }
        double phiTS = parallelsA.getNumericValue().doubleValue();
        double phiTSRad = Math.toRadians(phiTS);
        double cosPhiTS = Math.cos(phiTSRad);
        double sinPhiTS = Math.sin(phiTSRad);
        this.scaleK0_ = cosPhiTS;
        double sin2PhiTS = sinPhiTS * sinPhiTS;
        if (this.ellipsoid_) {
            this.scaleK0_ /= Math.sqrt(1.0 - sin2PhiTS * this.eccen2_);
            this.oneMinusE2_ = 1.0 - this.eccen2_;
            this.oneOver2E_ = 0.5 / this.eccen_;
            this.qP_ = this.calculateQforPhiRad(1.5707963267948966);
            double e4 = this.eccen2_ * this.eccen2_;
            double e6 = e4 * this.eccen2_;
            this.authTerm1_ = this.eccen2_ / 3.0 + 31.0 * e4 / 180.0 + 517.0 * e6 / 5040.0;
            this.authTerm2_ = 23.0 * e4 / 360.0 + 251.0 * e6 / 3780.0;
            this.authTerm3_ = 761.0 * e6 / 45360.0;
        }
        if (this.scaleK0_ == 0.0) {
            LOGGER.warn("Latitude of true scale is at the pole.");
            this.oneOverK0_ = Double.NaN;
        } else {
            this.oneOverK0_ = 1.0 / this.scaleK0_;
        }
    }

    private void setScalingFactor(double sfactor) {
        this.sfactor_ = sfactor;
        this.rS_ = this.ellipsoid_ ? this.semimajor_ * this.sfactor_ : this.radius_ * this.sfactor_;
        LOGGER.trace("S {} - RS {}", (Object)this.sfactor_, (Object)this.rS_);
        this.oneOverRS_ = 1.0 / this.rS_;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double x = this.scaleK0_ * lambdaRad;
        double y = this.ellipsoid_ ? 0.5 * this.calculateQforPhiRad(phiRad) * this.oneOverK0_ : Math.sin(phiRad) * this.oneOverK0_;
        return new Point2D.Double(x * this.rS_ + this.falseEasting_, y * this.rS_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double phiRad;
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double d = phiRad = this.ellipsoid_ ? this.calculatePhiRadForY(yy) : Math.asin(yy * this.scaleK0_ * this.oneOverRS_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = xx * this.oneOverRS_ * this.oneOverK0_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    private double calculateQforPhiRad(double phiRad) {
        double sinPhi = Math.sin(phiRad);
        double eSinPhi = this.eccen_ * sinPhi;
        double lnTerm = Math.log((1.0 - eSinPhi) / (1.0 + eSinPhi));
        return this.oneMinusE2_ * (sinPhi / (1.0 - eSinPhi * eSinPhi) - this.oneOver2E_ * lnTerm);
    }

    private double calculatePhiRadForY(double y) {
        double sinBeta = 2.0 * y * this.scaleK0_ / (this.semimajor_ * this.qP_);
        double betaRad = Math.asin(sinBeta);
        return betaRad + this.authTerm1_ * Math.sin(2.0 * betaRad) + this.authTerm2_ * Math.sin(4.0 * betaRad) + this.authTerm3_ * Math.sin(6.0 * betaRad);
    }
}

