from mipylib.numeric import stats

x = arange(0, 5, 0.01)
aa = [1, 1, 1, 1]
bb = [1, 2, 3, 10]
ss = ['-b', '-r', '-c', '-g']

#PDF
subplot(1,2,1)
for a,b,s in zip(aa,bb,ss):
    y = stats.pareto.pdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'$x = %i, \alpha = %i$' % (a, b))
#grid(True)
legend(loc='upper right', facecolor='w')
ylim(0, 10.5)
xlim(0, 5)
title('PDF')

#CDF
subplot(1,2,2)
for a,b,s in zip(aa,bb,ss):
    y = stats.pareto.cdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'$x = %i, \alpha = %i$' % (a, b))
#grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 1.1)
xlim(0, 5)
title('CDF')

suptitle('Pareto distribution')