fn = r'D:\Temp\binary\radar\Z_RADR_I_Z9898_20190828181529_O_DOR_SAD_CAP_FMT.bin'
f = addfile(fn)
slat = f.attrvalue('StationLatitude')[0]
slon = f.attrvalue('StationLongitude')[0]
h = f.attrvalue('AntennaHeight')[0]
scan = 0
rf = f['dBZ'][scan]
azi = f['azimuthR'][scan]
dis = f['distanceR'][:]
ele = f['elevationR'][scan]

#Get cartesian coordinates of data
x, y, z = RadarUtil.antenna_to_cartesian(dis, azi, ele, h)

#Set azimuth equidistant projection
proj = geolib.AzimuthalEquidistant(central_longitude=slon, central_latitude=slat)

#Plot        
ax = axesm(bgcolor='b', projection=proj, griddx=1, griddy=1)
#Add map layers
geoshow('cn_province', edgecolor=None, facecolor=[230,230,230])
geoshow('cn_province', edgecolor=[80,80,80])
city = geoshow('cn_cities', facecolor='r', size=8)
city.addlabels('NAME', fontname=u'黑体', fontsize=16, yoffset=18)
#Plot radar reflectivity
levs = [5,10,15,20,25,30,35,40,45,50,55,60,65,70]
cols = [(255,255,255,0),(102,255,255),(0,162,232),(86,225,250),(3,207,14),
    (26,152,7),(255,242,0),(217,172,113),(255,147,74),(255,0,0),
    (204,0,0),(155,0,0),(236,21,236),(130,11,130),(184,108,208)]
layer = pcolor(x, y, rf, levs, colors=cols, zorder=1, proj=proj)
colorbar(layer, shrink=0.8, label='dBZ', labelloc='top')
#Plot circles
cx, cy = project(slon, slat, toproj=proj)
rr = array([50, 100, 150, 200, 250, 300]) * 1000
for rd in rr:
    ax.add_circle((cx, cy), rd, edgecolor='r')
plot([cy,cy], [cx-rd,cx+rd], color='r', proj=proj)
plot([cy+rd,cy-rd], [cx,cx], color='r', proj=proj)
#Set plot
xlim(cx - rd, cx + rd)
ylim(cy - rd, cy + rd)
xaxis(tickin=False)
xaxis(tickvisible=False, location='top')
yaxis(tickin=False)
yaxis(tickvisible=False, location='right')
title('Radar reflectivity')